/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.support.ExitException;
import com.totsp.mavenplugin.gwt.support.GwtWebInfProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class MergeWebXmlMojo
extends AbstractGWTMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getProject().getProperties().getProperty("google.webtoolkit.home") == null) {
            File targetDir = null;
            try {
                targetDir = new File(this.getGwtBinDirectory(), this.guessArtifactId() + "-" + this.getGwtVersion()).getCanonicalFile();
                this.getProject().getProperties().setProperty("google.webtoolkit.home", targetDir.getCanonicalPath());
                GWT_PATH = targetDir.getCanonicalPath();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        try {
            File destination = new File(this.getBuildDir(), "web.xml");
            super.copyFile(this.getWebXml(), destination);
            for (int i = 0; i < this.getCompileTarget().length; ++i) {
                File moduleFile = null;
                Iterator it = this.getProject().getCompileSourceRoots().iterator();
                while (it.hasNext() && moduleFile == null) {
                    File check = new File(it.next().toString() + "/" + this.getCompileTarget()[i].replace('.', '/') + ".gwt.xml");
                    System.out.println("Looking for file: " + check.getAbsolutePath());
                    moduleFile = check.exists() ? check : moduleFile;
                }
                for (Resource r : this.getProject().getResources()) {
                    File check = new File(r.getDirectory() + "/" + this.getCompileTarget()[i].replace('.', '/') + ".gwt.xml");
                    System.out.println("Looking for file: " + check.getAbsolutePath());
                    moduleFile = check.exists() ? check : moduleFile;
                }
                this.fixThreadClasspath();
                GwtWebInfProcessor processor = null;
                System.out.println("Module file: " + moduleFile);
                try {
                    processor = moduleFile != null ? new GwtWebInfProcessor(this.getCompileTarget()[i], moduleFile, destination.getAbsolutePath(), destination.getAbsolutePath()) : new GwtWebInfProcessor(this.getCompileTarget()[i], destination.getAbsolutePath(), destination.getAbsolutePath());
                }
                catch (ExitException ee) {
                    this.getLog().warn((CharSequence)ee.getMessage());
                    return;
                }
                processor.process();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to merge web.xml", e);
        }
    }
}

