/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.scripting.ScriptUtil;
import com.totsp.mavenplugin.gwt.scripting.ScriptWriter;
import com.totsp.mavenplugin.gwt.scripting.ScriptWriterFactory;
import com.totsp.mavenplugin.gwt.scripting.TestResult;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GWTTestMojo
extends AbstractGWTMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isTestSkip()) {
            return;
        }
        this.getLog().info((CharSequence)("running GWTTestCase tests (using test name filter -  " + this.getTestFilter() + ")"));
        FileWriter testResultsWriter = null;
        ScriptWriter writer = ScriptWriterFactory.getInstance();
        writer.writeTestScripts(this);
        boolean testFailure = false;
        File testDir = new File(this.getBuildDir(), "gwtTest");
        WildcardFileFilter fileFilter = new WildcardFileFilter("gwtTest-*");
        File[] files = testDir.listFiles((FileFilter)fileFilter);
        for (int i = 0; i < files.length; ++i) {
            File test = files[i];
            try {
                String outTestName = test.getName();
                outTestName = outTestName.substring(0, test.getName().lastIndexOf("."));
                outTestName = outTestName.substring(8, outTestName.length());
                testResultsWriter = new FileWriter(new File(testDir, "TEST-" + outTestName + ".txt"));
                TestResult testResult = ScriptUtil.runTestScript(test);
                if (testResult.code == TestResult.TestCode.ERROR || testResult.code == TestResult.TestCode.FAILURE) {
                    testFailure = true;
                }
                testResultsWriter.write("Test Code - " + (Object)((Object)testResult.code) + "\n");
                testResultsWriter.write("Test Output: \n" + testResult.message + "\n");
                testResultsWriter.flush();
                testResultsWriter.close();
                this.getLog().info((CharSequence)(outTestName + " completed, GWTTestCase result: " + testResult.lastLine));
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("unable to create test results output file", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)("all tests completed - ran " + files.length + " tests - see results in target/gwtTest"));
        if (testFailure) {
            throw new MojoExecutionException("There were GWTTestCase test failures - see results in target/gwtTest");
        }
    }
}

