/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.scripting;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.DebugMojo;
import com.totsp.mavenplugin.gwt.scripting.ScriptWriter;
import com.totsp.mavenplugin.gwt.util.BuildClasspathUtil;
import com.totsp.mavenplugin.gwt.util.DependencyScope;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class ScriptWriterWindows
implements ScriptWriter {
    public File writeRunScript(AbstractGWTMojo mojo) throws MojoExecutionException {
        String filename = mojo instanceof DebugMojo ? "debug.cmd" : "run.cmd";
        File file = new File(mojo.getBuildDir(), filename);
        PrintWriter writer = this.getPrintWriterWithClasspath(mojo, file, DependencyScope.RUNTIME);
        String extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
        writer.print("\"" + AbstractGWTMojo.JAVA_COMMAND + "\" " + extra + " -cp %CLASSPATH% ");
        if (mojo instanceof DebugMojo) {
            writer.print(" -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,address=");
            writer.print(mojo.getDebugPort());
            writer.print(",suspend=y ");
        }
        writer.print("-Dcatalina.base=\"" + mojo.getTomcat().getAbsolutePath() + "\" ");
        writer.print(" com.google.gwt.dev.GWTShell");
        writer.print(" -gen \"");
        writer.print(mojo.getGen().getAbsolutePath());
        writer.print("\" -logLevel ");
        writer.print(mojo.getLogLevel());
        writer.print(" -style ");
        writer.print(mojo.getStyle());
        writer.print(" -out ");
        writer.print("\"" + mojo.getOutput().getAbsolutePath() + "\"");
        writer.print(" -port ");
        writer.print(Integer.toString(mojo.getPort()));
        if (mojo.isNoServer()) {
            writer.print(" -noserver ");
        }
        writer.print(" " + mojo.getRunTarget());
        writer.println();
        writer.flush();
        writer.close();
        return file;
    }

    public File writeCompileScript(AbstractGWTMojo mojo) throws MojoExecutionException {
        File file = new File(mojo.getBuildDir(), "compile.cmd");
        PrintWriter writer = this.getPrintWriterWithClasspath(mojo, file, DependencyScope.COMPILE);
        for (String target : mojo.getCompileTarget()) {
            String extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
            writer.print("\"" + AbstractGWTMojo.JAVA_COMMAND + "\" " + extra + " -cp %CLASSPATH% ");
            writer.print(" com.google.gwt.dev.GWTCompiler ");
            writer.print(" -gen \"");
            writer.print(mojo.getGen().getAbsolutePath());
            writer.print("\" -logLevel ");
            writer.print(mojo.getLogLevel());
            writer.print(" -style ");
            writer.print(mojo.getStyle());
            writer.print(" -out ");
            writer.print("\"" + mojo.getOutput().getAbsolutePath() + "\"");
            writer.print(" ");
            if (mojo.isEnableAssertions()) {
                writer.print(" -ea ");
            }
            writer.print(target);
            writer.println();
        }
        writer.flush();
        writer.close();
        return file;
    }

    public File writeI18nScript(AbstractGWTMojo mojo) throws MojoExecutionException {
        String extra;
        File file = new File(mojo.getBuildDir(), "i18n.cmd");
        if (!file.exists()) {
            if (mojo.getLog().isDebugEnabled()) {
                mojo.getLog().debug((CharSequence)("File '" + file.getAbsolutePath() + "' does not exsists, trying to create."));
            }
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                if (mojo.getLog().isDebugEnabled()) {
                    mojo.getLog().debug((CharSequence)("New file '" + file.getAbsolutePath() + "' created."));
                }
            }
            catch (Exception exe) {
                mojo.getLog().error((CharSequence)("Couldn't create file '" + file.getAbsolutePath() + "'. Reason: " + exe.getMessage()), (Throwable)exe);
            }
        }
        PrintWriter writer = this.getPrintWriterWithClasspath(mojo, file, DependencyScope.COMPILE);
        if (mojo.getI18nConstantsNames() != null) {
            for (String target : mojo.getI18nConstantsNames()) {
                extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
                writer.print("\"" + AbstractGWTMojo.JAVA_COMMAND + "\" " + extra + " -cp %CLASSPATH%");
                writer.print(" com.google.gwt.i18n.tools.I18NSync");
                writer.print(" -out ");
                writer.print("\"" + mojo.getI18nOutputDir() + "\"");
                writer.print(" ");
                writer.print(target);
                writer.println();
            }
        }
        if (mojo.getI18nMessagesNames() != null) {
            for (String target : mojo.getI18nMessagesNames()) {
                extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
                writer.print("\"" + AbstractGWTMojo.JAVA_COMMAND + "\" " + extra + " -cp %CLASSPATH%");
                writer.print(" com.google.gwt.i18n.tools.I18NSync");
                writer.print(" -createMessages ");
                writer.print(" -out ");
                writer.print("\"" + mojo.getI18nOutputDir() + "\"");
                writer.print(" ");
                writer.print(target);
                writer.println();
            }
        }
        writer.flush();
        writer.close();
        return file;
    }

    public void writeTestScripts(AbstractGWTMojo mojo) throws MojoExecutionException {
        String extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
        String testExtra = mojo.getExtraTestArgs() != null ? mojo.getExtraTestArgs() : "";
        File outputDir = new File(mojo.getBuildDir(), "gwtTest");
        outputDir.mkdirs();
        outputDir.mkdir();
        List testCompileRoots = mojo.getProject().getTestCompileSourceRoots();
        for (String currRoot : testCompileRoots) {
            Collection coll = FileUtils.listFiles((File)new File(currRoot), (IOFileFilter)new WildcardFileFilter(mojo.getTestFilter()), (IOFileFilter)HiddenFileFilter.VISIBLE);
            for (File currFile : coll) {
                String testName = currFile.toString();
                mojo.getLog().debug((CharSequence)("gwtTest test match found (after filter applied) - " + testName));
                if (testName.lastIndexOf(46) > testName.lastIndexOf(File.separatorChar)) {
                    testName = testName.substring(0, testName.lastIndexOf(46));
                }
                if (testName.startsWith(currRoot)) {
                    testName = testName.substring(currRoot.length());
                }
                if (testName.startsWith(File.separator)) {
                    testName = testName.substring(1);
                }
                testName = StringUtils.replace((String)testName, (char)File.separatorChar, (char)'.');
                mojo.getLog().debug((CharSequence)("testName after parsing - " + testName));
                File file = new File(mojo.getBuildDir() + File.separator + "gwtTest", "gwtTest-" + testName + ".cmd");
                PrintWriter writer = this.getPrintWriterWithClasspath(mojo, file, DependencyScope.TEST);
                writer.print("\"" + AbstractGWTMojo.JAVA_COMMAND + "\" ");
                if (extra.length() > 0) {
                    writer.print(" " + extra + " ");
                }
                if (testExtra.length() > 0) {
                    writer.print(" " + testExtra + " ");
                }
                writer.print(" -cp %CLASSPATH% ");
                writer.print("junit.textui.TestRunner ");
                writer.print(testName);
                writer.flush();
                writer.close();
            }
        }
    }

    private PrintWriter getPrintWriterWithClasspath(AbstractGWTMojo mojo, File file, DependencyScope scope) throws MojoExecutionException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            writer.println("@echo off");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating script - " + file, (Exception)e);
        }
        try {
            Collection<File> classpath = BuildClasspathUtil.buildClasspathList(mojo, scope);
            writer.print("set CLASSPATH=");
            StringBuffer cpString = new StringBuffer();
            for (File f : classpath) {
                cpString.append("\"" + f.getAbsolutePath() + "\";");
                if (cpString.length() <= 4000) continue;
                writer.println(cpString);
                cpString = new StringBuffer();
                writer.print("set CLASSPATH=%CLASSPATH%;");
            }
            writer.println(cpString);
            writer.println();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error creating script - " + file, (Exception)((Object)e));
        }
        writer.println();
        return writer;
    }
}

