/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.util;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.util.ArtifactNameUtil;
import com.totsp.mavenplugin.gwt.util.DependencyScope;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ActiveProjectArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildClasspathUtil {
    public static Collection<File> buildClasspathList(AbstractGWTMojo mojo, DependencyScope scope) throws DependencyResolutionRequiredException, MojoExecutionException {
        Iterator it;
        mojo.getLog().info((CharSequence)("establishing classpath list (buildClaspathList - scope = " + (Object)((Object)scope) + ")"));
        File gwtHome = mojo.getGwtHome();
        MavenProject project = mojo.getProject();
        LinkedHashSet<File> items = new LinkedHashSet<File>();
        if (gwtHome != null) {
            mojo.getLog().info((CharSequence)("google.webtoolkit.home (gwtHome) set, using it for GWT dependencies - " + gwtHome.getAbsolutePath()));
            items.addAll(BuildClasspathUtil.injectGwtDepsFromGwtHome(gwtHome, mojo));
        } else {
            mojo.getLog().info((CharSequence)"google.webtoolkit.home (gwtHome) *not* set, using project POM for GWT dependencies");
            items.addAll(BuildClasspathUtil.injectGwtDepsFromRepo(mojo));
        }
        if (mojo.getSourcesOnPath()) {
            BuildClasspathUtil.addSourcesWithActiveProjects(project, items, DependencyScope.COMPILE);
        }
        if (mojo.getResourcesOnPath()) {
            BuildClasspathUtil.addResourcesWithActiveProjects(project, items, DependencyScope.COMPILE);
        }
        items.add(new File(project.getBasedir(), "classes"));
        if (scope == DependencyScope.RUNTIME) {
            it = project.getRuntimeClasspathElements().iterator();
            while (it.hasNext()) {
                items.add(new File(it.next().toString()));
            }
        }
        if (scope == DependencyScope.TEST) {
            it = project.getTestClasspathElements().iterator();
            while (it.hasNext()) {
                items.add(new File(it.next().toString()));
            }
            BuildClasspathUtil.addSourcesWithActiveProjects(project, items, scope);
            BuildClasspathUtil.addResourcesWithActiveProjects(project, items, scope);
        }
        it = project.getCompileClasspathElements().iterator();
        while (it.hasNext()) {
            items.add(new File(it.next().toString()));
        }
        it = project.getSystemClasspathElements().iterator();
        while (it.hasNext()) {
            items.add(new File(it.next().toString()));
        }
        mojo.getLog().debug((CharSequence)"SCRIPT INJECTION CLASSPATH LIST");
        for (File f : items) {
            mojo.getLog().debug((CharSequence)("   " + f.getAbsolutePath()));
        }
        return items;
    }

    public static Collection<File> injectGwtDepsFromGwtHome(File gwtHome, AbstractGWTMojo mojo) {
        mojo.getLog().debug((CharSequence)"injecting gwt-user and gwt-dev for script classpath from google.webtoolkit.home (and expecting relative native libs)");
        LinkedHashSet<File> items = new LinkedHashSet<File>();
        File userJar = new File(gwtHome, "gwt-user.jar");
        File devJar = new File(gwtHome, ArtifactNameUtil.guessDevJarName());
        items.add(userJar);
        items.add(devJar);
        return items;
    }

    public static Collection<File> injectGwtDepsFromRepo(AbstractGWTMojo mojo) throws MojoExecutionException {
        mojo.getLog().debug((CharSequence)"injecting gwt-user and gwt-dev for script classpath from local repository (and expecting relative native libs)");
        LinkedHashSet<File> items = new LinkedHashSet<File>();
        Artifact gwtUser = mojo.getArtifactFactory().createArtifactWithClassifier("com.google.gwt", "gwt-user", mojo.getGwtVersion(), "jar", null);
        Artifact gwtDev = mojo.getArtifactFactory().createArtifactWithClassifier("com.google.gwt", "gwt-dev", mojo.getGwtVersion(), "jar", ArtifactNameUtil.getPlatformName());
        List remoteRepositories = mojo.getRemoteRepositories();
        try {
            mojo.getResolver().resolve(gwtUser, remoteRepositories, mojo.getLocalRepository());
            mojo.getResolver().resolve(gwtDev, remoteRepositories, mojo.getLocalRepository());
            items.add(gwtUser.getFile());
            items.add(gwtDev.getFile());
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("artifact not found - " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("artifact resolver problem - " + e.getMessage(), (Exception)((Object)e));
        }
        return items;
    }

    private static void addSourcesWithActiveProjects(MavenProject project, Set<File> items, DependencyScope scope) {
        List<Artifact> scopeArtifacts = BuildClasspathUtil.getScopeArtifacts(project, scope);
        BuildClasspathUtil.addSources(items, BuildClasspathUtil.getSourceRoots(project, scope));
        for (Artifact artifact : scopeArtifacts) {
            MavenProject refProject;
            if (!(artifact instanceof ActiveProjectArtifact) || (refProject = (MavenProject)project.getProjectReferences().get(BuildClasspathUtil.getProjectReferenceId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()))) == null) continue;
            BuildClasspathUtil.addSources(items, BuildClasspathUtil.getSourceRoots(refProject, scope));
        }
    }

    private static void addResourcesWithActiveProjects(MavenProject project, Set<File> items, DependencyScope scope) {
        List<Artifact> scopeArtifacts = BuildClasspathUtil.getScopeArtifacts(project, scope);
        BuildClasspathUtil.addResources(items, BuildClasspathUtil.getResources(project, scope));
        for (Artifact artifact : scopeArtifacts) {
            MavenProject refProject;
            if (!(artifact instanceof ActiveProjectArtifact) || (refProject = (MavenProject)project.getProjectReferences().get(BuildClasspathUtil.getProjectReferenceId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()))) == null) continue;
            BuildClasspathUtil.addResources(items, BuildClasspathUtil.getResources(refProject, scope));
        }
    }

    private static List<Artifact> getScopeArtifacts(MavenProject project, DependencyScope scope) {
        if (DependencyScope.COMPILE.equals((Object)scope)) {
            return project.getCompileArtifacts();
        }
        if (DependencyScope.TEST.equals((Object)scope)) {
            return project.getTestArtifacts();
        }
        throw new RuntimeException("Not allowed scope " + (Object)((Object)scope));
    }

    private static List getSourceRoots(MavenProject project, DependencyScope scope) {
        if (DependencyScope.COMPILE.equals((Object)scope)) {
            return project.getCompileSourceRoots();
        }
        if (DependencyScope.TEST.equals((Object)scope)) {
            return project.getTestCompileSourceRoots();
        }
        throw new RuntimeException("Not allowed scope " + (Object)((Object)scope));
    }

    private static List<Artifact> getResources(MavenProject project, DependencyScope scope) {
        if (DependencyScope.COMPILE.equals((Object)scope)) {
            return project.getResources();
        }
        if (DependencyScope.TEST.equals((Object)scope)) {
            return project.getTestResources();
        }
        throw new RuntimeException("Not allowed scope " + (Object)((Object)scope));
    }

    private static void addSources(Set<File> items, List sourceRoots) {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            items.add(new File(it.next().toString()));
        }
    }

    private static void addResources(Set<File> items, List resources) {
        for (Resource r : resources) {
            items.add(new File(r.getDirectory()));
        }
    }

    private static String getProjectReferenceId(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }
}

