/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GWTSetup
extends AbstractGWTMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getGwtVersion() == null) {
            throw new MojoExecutionException("You must set the \"gwtVersion\" property on the GWT plugin in order to use the setup goal.");
        }
        Dependency gwtDependency = new Dependency();
        gwtDependency.setGroupId(this.getGroupId());
        gwtDependency.setType(this.getType());
        gwtDependency.setArtifactId(GWTSetup.guessArtifactId());
        gwtDependency.setVersion(this.getGwtVersion());
        this.getProject().getModel().addDependency(gwtDependency);
        File targetDir = null;
        try {
            targetDir = new File(this.getGwtBinDirectory(), GWTSetup.guessArtifactId() + "-" + this.getGwtVersion()).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        try {
            this.getProject().getProperties().setProperty("google.webtoolkit.home", targetDir.getCanonicalPath());
            GWT_PATH = targetDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        if (OS_NAME.startsWith("mac") && this.getExtraJvmArgs() == null) {
            EXTA_ARG = "-XstartOnFirstThread";
        }
        try {
            this.addGwtSystemJarDependency(GWTSetup.guessDevJarName(), new File(targetDir, GWTSetup.guessDevJarName()));
            this.addGwtSystemJarDependency("gwt-servlet", new File(targetDir, "gwt-servlet.jar"));
            this.addGwtSystemJarDependency("gwt-user", new File(targetDir, "gwt-user.jar"));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage());
        }
    }

    public Dependency addGwtSystemJarDependency(String artifactId, File path) throws IOException {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.getGroupId());
        dependency.setType("jar");
        dependency.setArtifactId(artifactId);
        dependency.setVersion(this.getGwtVersion());
        dependency.setScope("system");
        dependency.setOptional(true);
        dependency.setSystemPath(path.getAbsolutePath());
        this.getProject().getModel().addDependency(dependency);
        if (!path.exists()) {
            path.getParentFile().mkdirs();
            path.createNewFile();
        }
        return dependency;
    }

    public static String guessArtifactId() {
        if (OS_NAME.startsWith("windows")) {
            return "gwt-windows";
        }
        if (OS_NAME.startsWith("mac")) {
            return "gwt-mac";
        }
        return "gwt-linux";
    }

    public static String guessDevJarName() {
        if (OS_NAME.startsWith("windows")) {
            return "gwt-dev-windows.jar";
        }
        if (OS_NAME.startsWith("mac")) {
            return "gwt-dev-mac.jar";
        }
        return "gwt-dev-linux.jar";
    }
}

