/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.antlr.v4.Tool;
import org.antlr.v4.parse.BlockSetTransformer;
import org.antlr.v4.parse.GrammarASTAdaptor;
import org.antlr.v4.parse.GrammarToken;
import org.antlr.v4.runtime.misc.DoubleKeyMap;
import org.antlr.v4.runtime.misc.Tuple2;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.ast.AltAST;
import org.antlr.v4.tool.ast.BlockAST;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.GrammarASTWithOptions;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.antlr.v4.tool.ast.RuleAST;
import org.antlr.v4.tool.ast.TerminalAST;

public class GrammarTransformPipeline {
    public Grammar g;
    public Tool tool;

    public GrammarTransformPipeline(Grammar g, Tool tool) {
        this.g = g;
        this.tool = tool;
    }

    public void process() {
        GrammarRootAST root = this.g.ast;
        if (root == null) {
            return;
        }
        this.tool.log("grammar", "before: " + root.toStringTree());
        this.integrateImportedGrammars(this.g);
        this.reduceBlocksToSets(root);
        this.expandParameterizedLoops(root);
        this.tool.log("grammar", "after: " + root.toStringTree());
    }

    public void reduceBlocksToSets(GrammarAST root) {
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((TreeAdaptor)new GrammarASTAdaptor(), (Object)root);
        GrammarASTAdaptor adaptor = new GrammarASTAdaptor();
        BlockSetTransformer transformer = new BlockSetTransformer((TreeNodeStream)nodes, this.g);
        transformer.setTreeAdaptor((TreeAdaptor)adaptor);
        transformer.downup((Object)root);
    }

    public void expandParameterizedLoops(GrammarAST root) {
        TreeVisitor v = new TreeVisitor((TreeAdaptor)new GrammarASTAdaptor());
        v.visit((Object)root, new TreeVisitorAction(){

            public Object pre(Object t) {
                if (((GrammarAST)((Object)t)).getType() == 3) {
                    return GrammarTransformPipeline.this.expandParameterizedLoop((GrammarAST)((Object)t));
                }
                return t;
            }

            public Object post(Object t) {
                return t;
            }
        });
    }

    public GrammarAST expandParameterizedLoop(GrammarAST t) {
        return t;
    }

    public static void setGrammarPtr(final Grammar g, GrammarAST tree) {
        if (tree == null) {
            return;
        }
        TreeVisitor v = new TreeVisitor((TreeAdaptor)new GrammarASTAdaptor());
        v.visit((Object)tree, new TreeVisitorAction(){

            public Object pre(Object t) {
                ((GrammarAST)((Object)t)).g = g;
                return t;
            }

            public Object post(Object t) {
                return t;
            }
        });
    }

    public static void augmentTokensWithOriginalPosition(Grammar g, GrammarAST tree) {
        if (tree == null) {
            return;
        }
        List<GrammarAST> optionsSubTrees = tree.getNodesWithType(81);
        for (int i = 0; i < optionsSubTrees.size(); ++i) {
            Map<String, GrammarAST> options;
            GrammarAST t = optionsSubTrees.get(i);
            CommonTree elWithOpt = t.parent;
            if (!(elWithOpt instanceof GrammarASTWithOptions) || !(options = ((GrammarASTWithOptions)elWithOpt).getOptions()).containsKey("tokenIndex")) continue;
            GrammarToken newTok = new GrammarToken(g, elWithOpt.getToken());
            newTok.originalTokenIndex = Integer.valueOf(options.get("tokenIndex").getText());
            elWithOpt.token = newTok;
            GrammarAST originalNode = g.ast.getNodeWithTokenIndex(newTok.getTokenIndex());
            if (originalNode != null) {
                elWithOpt.setTokenStartIndex(originalNode.getTokenStartIndex());
                elWithOpt.setTokenStopIndex(originalNode.getTokenStopIndex());
                continue;
            }
            elWithOpt.setTokenStartIndex(newTok.getTokenIndex());
            elWithOpt.setTokenStopIndex(newTok.getTokenIndex());
        }
    }

    public void integrateImportedGrammars(Grammar rootGrammar) {
        List<Grammar> imports = rootGrammar.getAllImportedGrammars();
        if (imports == null) {
            return;
        }
        GrammarRootAST root = rootGrammar.ast;
        GrammarAST id = (GrammarAST)root.getChild(0);
        GrammarASTAdaptor adaptor = new GrammarASTAdaptor(id.token.getInputStream());
        GrammarAST tokensRoot = (GrammarAST)root.getFirstChildWithType(65);
        List<GrammarAST> actionRoots = root.getNodesWithType(11);
        GrammarAST RULES = (GrammarAST)root.getFirstChildWithType(96);
        HashSet<String> rootRuleNames = new HashSet<String>();
        List<GrammarAST> rootRules = RULES.getNodesWithType(93);
        for (GrammarAST r : rootRules) {
            rootRuleNames.add(r.getChild(0).getText());
        }
        for (Grammar imp : imports) {
            GrammarAST optionsRoot;
            List<GrammarAST> rules;
            GrammarAST imp_tokensRoot = (GrammarAST)imp.ast.getFirstChildWithType(65);
            if (imp_tokensRoot != null) {
                rootGrammar.tool.log("grammar", "imported tokens: " + imp_tokensRoot.getChildren());
                if (tokensRoot == null) {
                    tokensRoot = adaptor.create(65, "TOKENS");
                    tokensRoot.g = rootGrammar;
                    root.insertChild(1, (Object)tokensRoot);
                }
                tokensRoot.addChildren(Arrays.asList(imp_tokensRoot.getChildren().toArray(new Tree[0])));
            }
            ArrayList<GrammarAST> all_actionRoots = new ArrayList<GrammarAST>();
            List<GrammarAST> imp_actionRoots = imp.ast.getAllChildrenWithType(11);
            if (actionRoots != null) {
                all_actionRoots.addAll(actionRoots);
            }
            all_actionRoots.addAll(imp_actionRoots);
            if (imp_actionRoots != null) {
                DoubleKeyMap namedActions = new DoubleKeyMap();
                rootGrammar.tool.log("grammar", "imported actions: " + imp_actionRoots);
                for (GrammarAST at : all_actionRoots) {
                    GrammarAST action;
                    GrammarAST name;
                    String scopeName = rootGrammar.getDefaultActionScope();
                    if (at.getChildCount() > 2) {
                        GrammarAST scope = (GrammarAST)at.getChild(0);
                        scopeName = scope.getText();
                        name = (GrammarAST)at.getChild(1);
                        action = (GrammarAST)at.getChild(2);
                    } else {
                        name = (GrammarAST)at.getChild(0);
                        action = (GrammarAST)at.getChild(1);
                    }
                    GrammarAST prevAction = (GrammarAST)((Object)namedActions.get((Object)scopeName, (Object)name.getText()));
                    if (prevAction == null) {
                        namedActions.put((Object)scopeName, (Object)name.getText(), (Object)action);
                        continue;
                    }
                    if (prevAction.g == at.g) {
                        rootGrammar.tool.errMgr.grammarError(ErrorType.ACTION_REDEFINITION, at.g.fileName, name.token, name.getText());
                        continue;
                    }
                    String s1 = prevAction.getText();
                    s1 = s1.substring(1, s1.length() - 1);
                    String s2 = action.getText();
                    s2 = s2.substring(1, s2.length() - 1);
                    String combinedAction = "{" + s1 + '\n' + s2 + "}";
                    prevAction.token.setText(combinedAction);
                }
                for (String scopeName : namedActions.keySet()) {
                    for (String name : namedActions.keySet((Object)scopeName)) {
                        GrammarAST action = (GrammarAST)((Object)namedActions.get((Object)scopeName, (Object)name));
                        rootGrammar.tool.log("grammar", action.g.name + " " + scopeName + ":" + name + "=" + action.getText());
                        if (action.g == rootGrammar) continue;
                        root.insertChild(1, action.getParent());
                    }
                }
            }
            if ((rules = imp.ast.getNodesWithType(93)) != null) {
                for (GrammarAST r : rules) {
                    rootGrammar.tool.log("grammar", "imported rule: " + r.toStringTree());
                    String name = r.getChild(0).getText();
                    boolean rootAlreadyHasRule = rootRuleNames.contains(name);
                    if (rootAlreadyHasRule) continue;
                    RULES.addChild((Tree)r);
                    rootRuleNames.add(name);
                }
            }
            if ((optionsRoot = (GrammarAST)imp.ast.getFirstChildWithType(42)) == null) continue;
            boolean hasNewOption = false;
            for (Map.Entry<String, GrammarAST> option : imp.ast.getOptions().entrySet()) {
                String rootOption;
                String importOption = imp.ast.getOptionString(option.getKey());
                if (importOption == null || importOption.equals(rootOption = rootGrammar.ast.getOptionString(option.getKey()))) continue;
                hasNewOption = true;
                break;
            }
            if (!hasNewOption) continue;
            rootGrammar.tool.errMgr.grammarError(ErrorType.OPTIONS_IN_DELEGATE, optionsRoot.g.fileName, optionsRoot.token, imp.name);
        }
        rootGrammar.tool.log("grammar", "Grammar: " + rootGrammar.ast.toStringTree());
    }

    public GrammarRootAST extractImplicitLexer(Grammar combinedGrammar) {
        GrammarRootAST combinedAST = combinedGrammar.ast;
        GrammarASTAdaptor adaptor = new GrammarASTAdaptor(combinedAST.token.getInputStream());
        GrammarAST[] elements = combinedAST.getChildren().toArray(new GrammarAST[0]);
        String lexerName = combinedAST.getChild(0).getText() + "Lexer";
        GrammarRootAST lexerAST = new GrammarRootAST((Token)new CommonToken(25, "LEXER_GRAMMAR"), combinedGrammar.ast.tokenStream);
        lexerAST.grammarType = 31;
        lexerAST.token.setInputStream(combinedAST.token.getInputStream());
        lexerAST.addChild((Tree)adaptor.create(28, lexerName));
        GrammarAST optionsRoot = (GrammarAST)combinedAST.getFirstChildWithType(42);
        if (optionsRoot != null && optionsRoot.getChildCount() != 0) {
            GrammarAST[] options;
            GrammarAST lexerOptionsRoot = adaptor.dupNode((Object)optionsRoot);
            lexerAST.addChild((Tree)lexerOptionsRoot);
            for (GrammarAST o : options = optionsRoot.getChildren().toArray(new GrammarAST[0])) {
                String string = o.getChild(0).getText();
                if (!Grammar.lexerOptions.contains(string) || Grammar.doNotCopyOptionsToLexer.contains(string)) continue;
                GrammarAST optionTree = (GrammarAST)((Object)adaptor.dupTree((Object)o));
                lexerOptionsRoot.addChild((Tree)optionTree);
                lexerAST.setOption(string, (GrammarAST)optionTree.getChild(1));
            }
        }
        ArrayList<GrammarAST> actionsWeMoved = new ArrayList<GrammarAST>();
        for (GrammarAST e : elements) {
            if (e.getType() != 11) continue;
            lexerAST.addChild((Tree)adaptor.dupTree((Object)e));
            if (!e.getChild(0).getText().equals("lexer")) continue;
            actionsWeMoved.add(e);
        }
        for (GrammarAST r : actionsWeMoved) {
            combinedAST.deleteChild((Tree)r);
        }
        GrammarAST combinedRulesRoot = (GrammarAST)combinedAST.getFirstChildWithType(96);
        if (combinedRulesRoot == null) {
            return lexerAST;
        }
        GrammarAST lexerRulesRoot = adaptor.create(96, "RULES");
        lexerAST.addChild((Tree)lexerRulesRoot);
        ArrayList<GrammarASTWithOptions> rulesWeMoved = new ArrayList<GrammarASTWithOptions>();
        GrammarASTWithOptions[] rules = combinedRulesRoot.getChildCount() > 0 ? combinedRulesRoot.getChildren().toArray(new GrammarASTWithOptions[0]) : new GrammarASTWithOptions[]{};
        for (GrammarASTWithOptions r : rules) {
            String ruleName = r.getChild(0).getText();
            if (!Grammar.isTokenName(ruleName)) continue;
            lexerRulesRoot.addChild((Tree)adaptor.dupTree((Object)r));
            rulesWeMoved.add(r);
        }
        for (GrammarAST grammarAST : rulesWeMoved) {
            combinedRulesRoot.deleteChild((Tree)grammarAST);
        }
        List<Tuple2<GrammarAST, GrammarAST>> litAliases = Grammar.getStringLiteralAliasesFromLexerRules(lexerAST);
        Set<String> set = combinedGrammar.getStringLiterals();
        int insertIndex = 0;
        block5: for (String lit : set) {
            if (litAliases != null) {
                for (Tuple2<GrammarAST, GrammarAST> pair : litAliases) {
                    GrammarAST litAST = (GrammarAST)((Object)pair.getItem2());
                    if (!lit.equals(litAST.getText())) continue;
                    continue block5;
                }
            }
            String rname = combinedGrammar.getStringLiteralLexerRuleName(lit);
            RuleAST litRule = new RuleAST(93);
            BlockAST blk = new BlockAST(77);
            AltAST alt = new AltAST(73);
            TerminalAST slit = new TerminalAST((Token)new CommonToken(62, lit));
            alt.addChild((Tree)slit);
            blk.addChild((Tree)alt);
            CommonToken idToken = new CommonToken(66, rname);
            litRule.addChild((Tree)new TerminalAST((Token)idToken));
            litRule.addChild((Tree)blk);
            lexerRulesRoot.insertChild(insertIndex, (Object)litRule);
            lexerRulesRoot.freshenParentAndChildIndexes();
            ++insertIndex;
        }
        lexerAST.sanityCheckParentAndChildIndexes();
        combinedAST.sanityCheckParentAndChildIndexes();
        combinedGrammar.tool.log("grammar", "after extract implicit lexer =" + combinedAST.toStringTree());
        combinedGrammar.tool.log("grammar", "lexer =" + lexerAST.toStringTree());
        if (lexerRulesRoot.getChildCount() == 0) {
            return null;
        }
        return lexerAST;
    }
}

