/*
 * Decompiled with CFR 0.152.
 */
package com.turbomanage.httpclient;

import com.turbomanage.httpclient.HttpResponse;
import com.turbomanage.httpclient.RequestLogger;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

public class ConsoleRequestLogger
implements RequestLogger {
    @Override
    public boolean isLoggingEnabled() {
        return true;
    }

    @Override
    public void log(String msg) {
        System.out.println(msg);
    }

    @Override
    public void logRequest(HttpURLConnection uc, Object content) throws IOException {
        this.log("=== HTTP Request ===");
        this.log(uc.getRequestMethod() + " " + uc.getURL().toString());
        if (content instanceof String) {
            this.log("Content: " + (String)content);
        }
        this.logHeaders(uc.getRequestProperties());
    }

    @Override
    public void logResponse(HttpResponse res) {
        if (res != null) {
            this.log("=== HTTP Response ===");
            this.log("Receive url: " + res.getUrl());
            this.log("Status: " + res.getStatus());
            this.logHeaders(res.getHeaders());
            this.log("Content:\n" + res.getBodyAsString());
        }
    }

    private void logHeaders(Map<String, List<String>> map) {
        if (map != null) {
            for (String field : map.keySet()) {
                List<String> headers = map.get(field);
                for (String header : headers) {
                    this.log(field + ":" + header);
                }
            }
        }
    }
}

