/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.twitter.elephantbird.util.PathFilters;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public final class HdfsUtils {
    private HdfsUtils() {
    }

    public static void walkPath(Path path, FileSystem fs, PathFilter filter, PathVisitor visitor) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(path);
        if (filter.accept(path)) {
            visitor.visit(fileStatus);
        }
        if (fileStatus.isDir()) {
            FileStatus[] children;
            for (FileStatus childStatus : children = fs.listStatus(path)) {
                HdfsUtils.walkPath(childStatus.getPath(), fs, filter, visitor);
            }
        }
    }

    public static void collectPaths(Path path, FileSystem fs, PathFilter filter, final List<Path> accumulator) throws IOException {
        HdfsUtils.walkPath(path, fs, filter, new PathVisitor(){

            @Override
            public void visit(FileStatus fileStatus) {
                accumulator.add(fileStatus.getPath());
            }
        });
    }

    public static long getDirectorySize(Path path, FileSystem fs, PathFilter filter) throws IOException {
        PathSizeVisitor visitor = new PathSizeVisitor();
        PathFilters.CompositePathFilter composite = new PathFilters.CompositePathFilter(PathFilters.newExcludeDirectoriesFilter(fs.getConf()), filter);
        HdfsUtils.walkPath(path, fs, composite, visitor);
        return visitor.getSize();
    }

    public static long getDirectorySize(Path path, FileSystem fs) throws IOException {
        ContentSummary cs = fs.getContentSummary(path);
        return cs.getLength();
    }

    public static List<Path> expandGlobs(List<String> pathsWithGlobs, Configuration conf) throws IOException {
        LinkedList paths = Lists.newLinkedList();
        for (String pathStr : pathsWithGlobs) {
            Path path = new Path(pathStr);
            FileSystem fs = path.getFileSystem(conf);
            FileStatus[] statuses = fs.globStatus(path);
            if (statuses == null) continue;
            for (FileStatus status : statuses) {
                paths.add(status.getPath());
            }
        }
        return paths;
    }

    private static class PathSizeVisitor
    implements PathVisitor {
        private long size = 0L;

        private PathSizeVisitor() {
        }

        @Override
        public void visit(FileStatus fileStatus) {
            this.size += fileStatus.getLen();
        }

        public long getSize() {
            return this.size;
        }
    }

    public static interface PathVisitor {
        public void visit(FileStatus var1);
    }

    public static class PathToQualifiedString
    implements Function<Path, String> {
        private Configuration conf;

        public PathToQualifiedString(Configuration conf) {
            this.conf = (Configuration)Preconditions.checkNotNull((Object)conf);
        }

        public String apply(Path path) {
            try {
                return path.getFileSystem(this.conf).makeQualified(path).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

