/*
 * Copyright 2009-2021 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright 2009-2021 Ping Identity Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2009-2021 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk.persist;



import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This class provides an OID allocator implementation that will generate OIDs
 * which are equal to the lowercase name of the associated attribute type or
 * object class followed by "-oid".  This will not result in an OID that is
 * technically valid, but is accepted by several directory servers.
 */
@NotMutable()
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DefaultOIDAllocator
       extends OIDAllocator
{
  /**
   * The singleton instance of this OID allocator.
   */
  @NotNull private static final DefaultOIDAllocator INSTANCE =
       new DefaultOIDAllocator();



  /**
   * The serial version UID for this serializable class.
   */
  private static final long serialVersionUID = 4815405566303309719L;



  /**
   * Creates a new instance of this OID allocator.
   */
  private DefaultOIDAllocator()
  {
    // No implementation required.
  }



  /**
   * Retrieves the singleton instance of this OID allocator.
   *
   * @return  The singleton instance of this OID allocator.
   */
  @NotNull()
  public static DefaultOIDAllocator getInstance()
  {
    return INSTANCE;
  }



  /**
   * {@inheritDoc}
   */
  @Override()
  @NotNull()
  public String allocateAttributeTypeOID(@NotNull final String name)
  {
    return StaticUtils.toLowerCase(name) + "-oid";
  }



  /**
   * {@inheritDoc}
   */
  @Override()
  @NotNull()
  public String allocateObjectClassOID(@NotNull final String name)
  {
    return StaticUtils.toLowerCase(name) + "-oid";
  }
}
