/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.conversions;

import com.univocity.parsers.annotations.helpers.AnnotationHelper;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.conversions.FormattedConversion;
import com.univocity.parsers.conversions.ObjectConversion;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.Arrays;

public abstract class NumericConversion<T extends Number>
extends ObjectConversion<T>
implements FormattedConversion<DecimalFormat> {
    private DecimalFormat[] formatters = new DecimalFormat[0];
    private String[] formats = new String[0];
    private final ParsePosition position = new ParsePosition(0);

    public NumericConversion(T valueIfStringIsNull, String valueIfObjectIsNull, String ... numericFormats) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Numeric formats", numericFormats);
        this.formats = (String[])numericFormats.clone();
        this.formatters = new DecimalFormat[numericFormats.length];
        for (int i = 0; i < numericFormats.length; ++i) {
            String numericFormat = numericFormats[i];
            this.formatters[i] = new DecimalFormat(numericFormat);
            this.configureFormatter(this.formatters[i]);
        }
    }

    public NumericConversion(T valueIfStringIsNull, String valueIfObjectIsNull, DecimalFormat ... numericFormatters) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Numeric formatters", numericFormatters);
        this.formatters = (DecimalFormat[])numericFormatters.clone();
        this.formats = new String[numericFormatters.length];
        for (int i = 0; i < numericFormatters.length; ++i) {
            this.formats[i] = numericFormatters[i].toPattern();
        }
    }

    public NumericConversion(T valueIfStringIsNull, String valueIfObjectIsNull) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
    }

    public NumericConversion(String ... numericFormats) {
        this((null), (String)null, numericFormats);
    }

    public NumericConversion(DecimalFormat ... numericFormatters) {
        this((null), (String)null, numericFormatters);
    }

    public NumericConversion() {
    }

    public DecimalFormat[] getFormatterObjects() {
        return this.formatters;
    }

    protected abstract void configureFormatter(DecimalFormat var1);

    @Override
    protected T fromString(String input) {
        for (int i = 0; i < this.formatters.length; ++i) {
            this.position.setIndex(0);
            Number out = this.formatters[i].parse(input, this.position);
            if (this.position.getIndex() < input.length() && this.formatters.length > 1) continue;
            return (T)out;
        }
        throw new IllegalArgumentException("Cannot parse '" + input + "' as a valid number. Supported formats are: " + Arrays.toString(this.formats));
    }

    @Override
    public String revert(T input) {
        if (input == null) {
            return super.revert((Object)null);
        }
        for (DecimalFormat formatter : this.formatters) {
            try {
                return formatter.format(input);
            }
            catch (Throwable ex) {
            }
        }
        throw new IllegalStateException("Cannot format '" + input + "'. No valid formatters were defined.");
    }

    public void addFormat(String format, String ... formatOptions) {
        DecimalFormat formatter = new DecimalFormat(format);
        this.configureFormatter(formatter);
        AnnotationHelper.applyFormatSettings(formatter, formatOptions);
        this.formats = Arrays.copyOf(this.formats, this.formats.length + 1);
        this.formatters = Arrays.copyOf(this.formatters, this.formatters.length + 1);
        this.formats[this.formats.length - 1] = format;
        this.formatters[this.formatters.length - 1] = formatter;
    }
}

