/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.feedback;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.feedback.FeedbackClient;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.JsonObject;
import java.util.HashMap;
import java.util.Optional;

public class FeedbackHandler
implements CopilotCommand {
    private final String[] expectedData = new String[]{"type", "email", "description"};
    private final FeedbackClient client = new FeedbackClient();

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("feedback")) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : this.expectedData) {
                map.put(key, data.getString(key));
            }
            String userKey = ProjectHelpers.getUserKey();
            String proKey = Optional.ofNullable(LocalProKey.get()).map(ProKey::toJson).orElse(null);
            this.client.sendFeedback(userKey, proKey, map);
            return true;
        }
        return false;
    }
}

