/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.AllowInterceptor;
import org.atmosphere.util.Utils;

public class PaddingAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(PaddingAtmosphereInterceptor.class);
    private final byte[] padding;
    private final String paddingText;

    public PaddingAtmosphereInterceptor() {
        this.paddingText = PaddingAtmosphereInterceptor.confPadding(2048);
        this.padding = this.paddingText.getBytes();
    }

    public PaddingAtmosphereInterceptor(int size) {
        this.paddingText = PaddingAtmosphereInterceptor.confPadding(size);
        this.padding = this.paddingText.getBytes();
    }

    protected static final String confPadding(int size) {
        StringBuilder whitespace = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        return whitespace.toString();
    }

    private void writePadding(AtmosphereResponse response) {
        AtmosphereRequest request = response.request();
        if (request != null && request.getAttribute("paddingWritten") != null) {
            return;
        }
        if (response.resource() != null && response.resource().transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING)) {
            request.setAttribute(FrameworkConfig.TRANSPORT_IN_USE, "streaming");
            response.setContentType("text/plain");
        }
        response.write(this.padding, true);
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        boolean padding;
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        final AtmosphereResponse response = r.getResponse();
        final AtmosphereRequest request = r.getRequest();
        String uuid = request.getHeader("X-Atmosphere-tracking-id");
        boolean bl = padding = r.transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING) || r.transport().equals((Object)AtmosphereResource.TRANSPORT.LONG_POLLING);
        if (uuid != null && !uuid.equals("0") && r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET) && request.getAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE) != null) {
            padding = true;
        }
        if (padding) {
            r.addEventListener(new ForcePreSuspend(response));
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                    private void padding() {
                        if (!r.isSuspended()) {
                            PaddingAtmosphereInterceptor.this.writePadding(response);
                            request.setAttribute("paddingWritten", "true");
                        }
                    }

                    @Override
                    public void prePayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        this.padding();
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                    }
                });
            } else {
                logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "Browser Padding Interceptor Support";
    }

    public final class ForcePreSuspend
    extends AtmosphereResourceEventListenerAdapter
    implements AllowInterceptor {
        private final AtmosphereResponse response;

        public ForcePreSuspend(AtmosphereResponse response) {
            this.response = response;
        }

        @Override
        public void onPreSuspend(AtmosphereResourceEvent event) {
            PaddingAtmosphereInterceptor.this.writePadding(this.response);
            event.getResource().removeEventListener(this);
        }
    }
}

