/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public final class TemplateRenderer<SOURCE>
extends Renderer<SOURCE> {
    private static final Pattern BINDING_MISSING_DOLLAR = Pattern.compile("\\s(class|style)\\s*=\\s*['\"]?[{\\[]{2}");

    public static <SOURCE> TemplateRenderer<SOURCE> of(String template) {
        Objects.requireNonNull(template);
        TemplateRenderer.warnIfClassOrStyleWithoutDollar(template);
        TemplateRenderer<SOURCE> renderer = new TemplateRenderer<SOURCE>(template);
        return renderer;
    }

    private static void warnIfClassOrStyleWithoutDollar(String template) {
        if (TemplateRenderer.hasClassOrStyleWithoutDollar(template)) {
            LoggerFactory.getLogger(TemplateRenderer.class).warn("Bindings for 'class' and 'style' need a $ prefix (e.g. 'class$=\"[[item.className]]\"') to use an attribute binding instead of a property binding. Apparent omission detected in the template '{}'", (Object)template);
        }
    }

    static boolean hasClassOrStyleWithoutDollar(String template) {
        return BINDING_MISSING_DOLLAR.matcher(template).find();
    }

    private TemplateRenderer(String template) {
        super(template);
    }

    public TemplateRenderer<SOURCE> withProperty(String property, ValueProvider<SOURCE, ?> provider) {
        this.setProperty(property, provider);
        return this;
    }

    public TemplateRenderer<SOURCE> withEventHandler(String handlerName, SerializableConsumer<SOURCE> handler) {
        this.setEventHandler(handlerName, handler);
        return this;
    }
}

