/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.littemplate;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.littemplate.IllegalAttributeException;
import com.vaadin.flow.component.template.internal.AbstractInjectableElementInitializer;
import com.vaadin.flow.dom.Element;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableLitElementInitializer
extends AbstractInjectableElementInitializer {
    private static final String DYNAMIC_ATTRIBUTE_PREFIX = "Template {} contains an attribute {} in element {} which";
    private final Class<? extends Component> templateClass;

    public InjectableLitElementInitializer(Element element, Class<? extends Component> templateClass) {
        super(element);
        this.templateClass = templateClass;
    }

    public void accept(Map<String, String> templateAttributes) {
        if (templateAttributes.containsKey("disabled")) {
            String errorMessage = String.format("Lit template '%s' injected element '%s' with id '%s' uses the disabled attribute.%nMapped components should instead be disabled using the 'setEnabled(false)' method on the server side.", this.templateClass.getName(), this.getElement().getTag(), templateAttributes.get("id"));
            throw new IllegalAttributeException(errorMessage);
        }
        super.accept(templateAttributes);
    }

    protected boolean isStaticAttribute(String name, String value) {
        if (name.startsWith("?")) {
            InjectableLitElementInitializer.getLogger().debug("{} starts with '?' and ignored by initialization since this is an attribute binding", new Object[]{DYNAMIC_ATTRIBUTE_PREFIX, this.templateClass.getSimpleName(), name, this.getElement().getTag()});
            return false;
        }
        if (name.startsWith(".")) {
            InjectableLitElementInitializer.getLogger().debug("{} starts with '.' and ignored by initialization since this is a property binding", new Object[]{DYNAMIC_ATTRIBUTE_PREFIX, this.templateClass.getSimpleName(), name, this.getElement().getTag()});
            return false;
        }
        if (name.startsWith("@")) {
            InjectableLitElementInitializer.getLogger().debug("{} starts with '@' and ignored by initialization since this is an event listener declration", new Object[]{DYNAMIC_ATTRIBUTE_PREFIX, this.templateClass.getSimpleName(), name, this.getElement().getTag()});
            return false;
        }
        if (value == null) {
            return true;
        }
        if (value.contains("${") && value.contains("}")) {
            InjectableLitElementInitializer.getLogger().debug("Template {} contains an attribute {} in element {} whose value is dynamic and it's ignored by initialization", new Object[]{this.templateClass.getSimpleName(), name, this.getElement().getTag()});
            return false;
        }
        return true;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(InjectableLitElementInitializer.class);
    }
}

