/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.server.startup.RouteTarget;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfiguredRoutes
implements Serializable {
    private final Map<String, RouteTarget> routes;
    private final Map<Class<? extends Component>, String> targetRoutes;
    private final Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargets;

    public ConfiguredRoutes() {
        this.routes = Collections.emptyMap();
        this.targetRoutes = Collections.emptyMap();
        this.exceptionTargets = Collections.emptyMap();
    }

    public ConfiguredRoutes(ConfigureRoutes original) {
        HashMap<String, RouteTarget> routeMap = new HashMap<String, RouteTarget>();
        HashMap<Class<? extends Component>, String> targetRouteMap = new HashMap<Class<? extends Component>, String>();
        HashMap<Class<? extends Exception>, Class<? extends Component>> exceptionTargetMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
        for (Map.Entry<String, RouteTarget> route : original.getRoutesMap().entrySet()) {
            routeMap.put(route.getKey(), route.getValue().copy(false));
        }
        targetRouteMap.putAll(original.getTargetRoutes());
        exceptionTargetMap.putAll(original.getExceptionHandlers());
        this.routes = routeMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(routeMap);
        this.targetRoutes = targetRouteMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(targetRouteMap);
        this.exceptionTargets = exceptionTargetMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(exceptionTargetMap);
    }

    protected Map<String, RouteTarget> getRoutesMap() {
        return this.routes;
    }

    protected List<String> getRoutePaths(Class<? extends Component> routeTarget) {
        return this.getRoutesMap().entrySet().stream().filter(entry -> ((RouteTarget)entry.getValue()).containsTarget(routeTarget)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean hasRoute(String path) {
        return this.getRoutesMap().containsKey(path);
    }

    public boolean hasRoute(String pathString, List<String> segments) {
        if (this.hasRoute(pathString)) {
            return this.getRouteTarget(pathString).getTarget(segments) != null;
        }
        return false;
    }

    public boolean hasRouteTarget(Class<? extends Component> targetRoute) {
        return this.getTargetRoutes().containsKey(targetRoute);
    }

    public Optional<Class<? extends Component>> getRoute(String pathString, List<String> segments) {
        if (this.hasRoute(pathString)) {
            RouteTarget routeTarget = this.getRouteTarget(pathString);
            return Optional.ofNullable(routeTarget.getTarget(segments));
        }
        return Optional.empty();
    }

    public Set<String> getRoutes() {
        return Collections.unmodifiableSet(this.getRoutesMap().keySet());
    }

    public Map<Class<? extends Component>, String> getTargetRoutes() {
        return this.targetRoutes;
    }

    public String getTargetRoute(Class<? extends Component> navigationTarget) {
        return this.getTargetRoutes().get(navigationTarget);
    }

    public Class<? extends Component> getExceptionHandlerByClass(Class<?> exceptionClass) {
        return this.getExceptionHandlers().get(exceptionClass);
    }

    public Map<Class<? extends Exception>, Class<? extends Component>> getExceptionHandlers() {
        return this.exceptionTargets;
    }

    public List<Class<? extends RouterLayout>> getParentLayouts(String path, Class<? extends Component> navigationTarget) {
        return this.getRouteTarget(path).getParentLayouts(navigationTarget);
    }

    protected RouteTarget getRouteTarget(String path) {
        return this.getRoutesMap().get(path);
    }
}

