/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DebouncePhase {
    LEADING("leading"),
    INTERMEDIATE("intermediate"),
    TRAILING("trailing");

    private static final Map<String, DebouncePhase> INSTANCES;
    private String identifier;

    private DebouncePhase(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static DebouncePhase forIdentifier(String identifier) {
        DebouncePhase phase = INSTANCES.get(identifier);
        if (phase == null) {
            throw new IllegalArgumentException("Unsupported debounce phase identifier: " + identifier);
        }
        return phase;
    }

    static {
        INSTANCES = Stream.of(DebouncePhase.values()).collect(Collectors.toMap(DebouncePhase::getIdentifier, Function.identity()));
    }
}

