/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.router.RouterLayout;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class RouteBaseData<T extends RouteBaseData>
implements Comparable<T>,
Serializable {
    private final List<Class<? extends RouterLayout>> parentLayouts;
    private final String template;
    private final Map<String, RouteParameterData> parameters;
    private final Class<? extends Component> navigationTarget;

    public RouteBaseData(List<Class<? extends RouterLayout>> parentLayouts, String template, List<Class<?>> parameters, Class<? extends Component> navigationTarget) {
        if (parameters != null && !parameters.isEmpty()) {
            throw new IllegalArgumentException("Please provide an empty parameters list or use the constructor receiving the parameters as a Map");
        }
        this.parentLayouts = Collections.unmodifiableList(parentLayouts);
        this.template = template;
        this.parameters = Collections.emptyMap();
        this.navigationTarget = navigationTarget;
    }

    public RouteBaseData(List<Class<? extends RouterLayout>> parentLayouts, String template, Map<String, RouteParameterData> parameters, Class<? extends Component> navigationTarget) {
        this.parentLayouts = Collections.unmodifiableList(parentLayouts);
        this.template = template;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.navigationTarget = navigationTarget;
    }

    public Class<? extends RouterLayout> getParentLayout() {
        if (this.parentLayouts.isEmpty()) {
            return null;
        }
        return this.parentLayouts.get(0);
    }

    public List<Class<? extends RouterLayout>> getParentLayouts() {
        return this.parentLayouts;
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, RouteParameterData> getRouteParameters() {
        return this.parameters;
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget;
    }

    @Override
    public int compareTo(T otherRouteData) {
        return this.getTemplate().compareToIgnoreCase(((RouteBaseData)otherRouteData).getTemplate());
    }

    public boolean equals(Object obj) {
        if (obj instanceof RouteBaseData) {
            RouteBaseData other = (RouteBaseData)obj;
            return other.parentLayouts.equals(this.parentLayouts) && other.template.equals(this.template) && other.navigationTarget.equals(this.navigationTarget);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.parentLayouts, this.template, this.parameters, this.navigationTarget);
    }
}

