/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.themeeditor.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CssRule
implements Cloneable {
    private String selector;
    private Map<String, String> properties;

    public CssRule() {
        this.properties = new HashMap<String, String>();
    }

    public CssRule(String selector, Map<String, String> properties) {
        this.selector = selector;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public CssRule(String selector, String property, String value) {
        this.selector = selector;
        this.properties = Collections.singletonMap(property, value);
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public CssRule clone() {
        return new CssRule(this.selector, this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssRule cssRule = (CssRule)o;
        return Objects.equals(this.selector, cssRule.selector) && Objects.equals(this.properties, cssRule.properties);
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CssRule[");
        sb.append(this.selector + "{");
        this.properties.forEach((k, v) -> sb.append((String)k).append(":").append((String)v).append(";"));
        return sb.append("}]").toString();
    }
}

