/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestartMonitor {
    private final Lock lock = new ReentrantLock();
    private final Condition serverRestartedCondition = this.lock.newCondition();
    private volatile boolean serverRestarting = false;
    private final Pattern restarting;
    private final Pattern restarted;

    RestartMonitor(Pattern restarting, Pattern restarted) {
        this.restarting = restarting;
        this.restarted = restarted;
    }

    void parseLine(String line) {
        if (this.restarting.matcher(line).find()) {
            this.serverRestarting();
        } else if (this.restarted.matcher(line).find()) {
            this.serverRestarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServerReady() {
        this.lock.lock();
        try {
            while (this.serverRestarting) {
                String threadName = Thread.currentThread().getName();
                long threadId = Thread.currentThread().getId();
                this.getLogger().trace("Thread {} ({}) waiting for dev server restart...", (Object)threadName, (Object)threadId);
                if (this.serverRestartedCondition.await(60L, TimeUnit.SECONDS)) {
                    this.getLogger().trace("Thread {} ({}) continues execution after server restarts", (Object)threadName, (Object)threadId);
                    continue;
                }
                this.getLogger().trace("Thread {} ({}) continues execution after waiting for 60 seconds for a restart to complete", (Object)threadName, (Object)threadId);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void serverRestarting() {
        this.lock.lock();
        try {
            this.getLogger().debug("Dev server is restarting...");
            this.serverRestarting = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void serverRestarted() {
        this.lock.lock();
        try {
            this.serverRestarting = false;
            this.getLogger().debug("Dev server restarted");
            this.serverRestartedCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(RestartMonitor.class);
    }
}

