/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.ColumnGroup;
import com.vaadin.flow.component.grid.ColumnGroupHelpers;
import com.vaadin.flow.component.grid.ColumnLayer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

abstract class AbstractRow<CELL extends AbstractCell>
implements Serializable {
    protected ColumnLayer layer;
    protected List<CELL> cells;
    private SerializableFunction<AbstractColumn<?>, CELL> cellCtor;

    AbstractRow(ColumnLayer layer, SerializableFunction<AbstractColumn<?>, CELL> cellCtor) {
        this.layer = layer;
        this.cellCtor = cellCtor;
        this.cells = layer.getColumns().stream().map(cellCtor).collect(Collectors.toList());
    }

    protected void setLayer(ColumnLayer layer) {
        this.layer = layer;
        this.setColumns(layer.getColumns());
    }

    protected void setColumns(List<AbstractColumn<?>> columns) {
        assert (columns.size() == this.cells.size());
        IntStream.range(0, columns.size()).forEach(i -> ((AbstractCell)this.cells.get(i)).setColumn((AbstractColumn)columns.get(i)));
    }

    protected void addCell(int index, AbstractColumn<?> column) {
        this.cells.add(index, this.cellCtor.apply(column));
    }

    protected void removeCell(AbstractColumn<?> columnComponent) {
        AbstractCell cellToRemove = this.cells.stream().filter(cell -> cell.getColumn().equals(columnComponent)).findFirst().orElseThrow(() -> new IllegalStateException("removeCell() should never be called for a column component that doesn't have a corresponding cell in this row."));
        this.cells.remove(cellToRemove);
    }

    public List<CELL> getCells() {
        return Collections.unmodifiableList(this.cells);
    }

    public CELL getCell(Grid.Column<?> column) {
        return this.getCellFor(column);
    }

    private CELL getCellFor(AbstractColumn<?> column) {
        return (CELL)this.getCells().stream().filter(cell -> cell.getColumn() == column).findFirst().orElseGet(() -> {
            Optional parent = column.getParent();
            if (parent.isPresent() && parent.get() instanceof AbstractColumn) {
                return this.getCellFor((AbstractColumn)parent.get());
            }
            throw new IllegalArgumentException("Cannot find a cell from this row that would correspond to the given column");
        });
    }

    public CELL join(Grid.Column<?> ... columns) {
        return this.join(Arrays.stream(columns).map(this::getCell).collect(Collectors.toList()));
    }

    public CELL join(CELL ... cells) {
        return this.join((Collection<CELL>)Arrays.asList(cells));
    }

    public CELL join(Collection<CELL> cells) {
        Grid<?> grid = this.layer.getGrid();
        if (!this.isOutmostRow()) {
            throw new IllegalArgumentException("Cells can be joined only on the top-most HeaderRow or the bottom-most FooterRow.");
        }
        if (cells.size() < 2) {
            throw new IllegalArgumentException("Cannot join less than 2 cells");
        }
        if (!this.cells.containsAll(cells)) {
            throw new IllegalArgumentException("Cannot join cells that don't belong to this row");
        }
        List sortedCells = cells.stream().sorted((c1, c2) -> Integer.compare(this.cells.indexOf(c1), this.cells.indexOf(c2))).collect(Collectors.toList());
        int cellInsertIndex = this.cells.indexOf(sortedCells.get(0));
        IntStream.range(0, sortedCells.size()).forEach(i -> {
            if (this.cells.indexOf(sortedCells.get(i)) != cellInsertIndex + i) {
                throw new IllegalArgumentException("Cannot join cells that are not adjacent");
            }
        });
        List<AbstractColumn<?>> columnsToJoin = sortedCells.stream().map(AbstractCell::getColumn).collect(Collectors.toList());
        List<Grid.Column<?>> bottomColumnsToJoin = columnsToJoin.stream().flatMap(col -> col.getBottomChildColumns().stream()).collect(Collectors.toList());
        List<ColumnLayer> layers = grid.getColumnLayers();
        int layerInsertIndex = this.findFirstPossibleInsertIndex(bottomColumnsToJoin, layers);
        if (layerInsertIndex == layers.indexOf(this.layer) + 1) {
            return this.joinCellsInPlace(cells, columnsToJoin, cellInsertIndex);
        }
        return this.moveColumnLayerAndJoinCells(cells, columnsToJoin, bottomColumnsToJoin, layers, layerInsertIndex, grid);
    }

    private int findFirstPossibleInsertIndex(List<Grid.Column<?>> bottomColumnsToJoin, List<ColumnLayer> layers) {
        for (int i = layers.indexOf(this.layer) + 1; i < layers.size(); ++i) {
            ColumnLayer possibleParentLayer = layers.get(i);
            boolean hasCommonParentColumnForColumnsToJoin = possibleParentLayer.getColumns().stream().anyMatch(column -> column.getBottomChildColumns().containsAll(bottomColumnsToJoin));
            if (hasCommonParentColumnForColumnsToJoin) {
                return i;
            }
            List joinedColumns = possibleParentLayer.getColumns().stream().filter(col -> ((ColumnGroup)col).getChildColumns().size() > 1).collect(Collectors.toList());
            boolean otherColumnsJoined = joinedColumns.stream().flatMap(col -> col.getBottomChildColumns().stream()).anyMatch(col -> !bottomColumnsToJoin.contains(col));
            if (!otherColumnsJoined) continue;
            throw new IllegalArgumentException("This set of cells can not be joined because of the hierarchical column group structure of the client-side web component.");
        }
        return layers.size();
    }

    private CELL joinCellsInPlace(Collection<CELL> cellsToJoin, List<AbstractColumn<?>> columnsToJoin, int cellInsertIndex) {
        Element parent = columnsToJoin.get(0).getElement().getParent();
        int elementInsertIndex = columnsToJoin.stream().mapToInt(col -> parent.indexOfChild(col.getElement())).min().getAsInt();
        columnsToJoin.forEach(col -> col.getElement().removeFromParent());
        ArrayList childColumns = new ArrayList();
        columnsToJoin.forEach(col -> childColumns.addAll(((ColumnGroup)col).getChildColumns()));
        ColumnGroup group = new ColumnGroup(this.layer.getGrid(), childColumns);
        parent.insertChild(elementInsertIndex, new Element[]{group.getElement()});
        this.layer.addColumn(cellInsertIndex, group);
        this.layer.getColumns().removeAll(columnsToJoin);
        this.cells.removeAll(cellsToJoin);
        return (CELL)((AbstractCell)this.cells.get(cellInsertIndex));
    }

    private CELL moveColumnLayerAndJoinCells(Collection<CELL> cellsToJoin, List<AbstractColumn<?>> columnsToJoin, List<Grid.Column<?>> bottomColumnsToJoin, List<ColumnLayer> layers, int layerInsertIndex, Grid<?> grid) {
        grid.removeColumnLayer(this.layer);
        ColumnLayer lowerLayer = layers.get(--layerInsertIndex - 1);
        List<AbstractColumn<?>> childColumns = lowerLayer.getColumns().stream().filter(col -> bottomColumnsToJoin.containsAll(col.getBottomChildColumns())).collect(Collectors.toList());
        ArrayList newColumns = new ArrayList();
        Iterator leftColumns = this.layer.getColumns().stream().filter(column -> !columnsToJoin.contains(column)).iterator();
        ArrayList<CELL> newCells = new ArrayList<CELL>();
        Iterator leftCells = this.cells.stream().filter(cell -> !cellsToJoin.contains(cell)).iterator();
        AbstractCell newCell = null;
        for (AbstractColumn<?> col2 : lowerLayer.getColumns()) {
            if (childColumns.contains(col2)) {
                if (newCell != null) continue;
                ColumnGroup groupForNewCell = ColumnGroupHelpers.wrapInColumnGroup(grid, childColumns);
                newColumns.add(groupForNewCell);
                newCell = (AbstractCell)this.cellCtor.apply((Object)groupForNewCell);
                newCells.add(newCell);
                continue;
            }
            ColumnGroup group = ColumnGroupHelpers.wrapInColumnGroup(grid, col2);
            AbstractColumn oldGroup = (AbstractColumn)leftColumns.next();
            group.setHeaderRenderer(oldGroup.getHeaderRenderer());
            group.setFooterRenderer(oldGroup.getFooterRenderer());
            newColumns.add(group);
            AbstractCell next = (AbstractCell)leftCells.next();
            next.setColumn(group);
            newCells.add(next);
        }
        ColumnLayer newLayer = grid.insertColumnLayer(layerInsertIndex, newColumns);
        this.cells = newCells;
        if (this.layer.isHeaderRow()) {
            newLayer.setHeaderRow(this.layer.asHeaderRow());
        }
        if (this.layer.isFooterRow()) {
            newLayer.setFooterRow(this.layer.asFooterRow());
        }
        return (CELL)newCell;
    }

    protected abstract boolean isOutmostRow();

    public static abstract class AbstractCell
    implements Serializable {
        private AbstractColumn<?> columnComponent;

        AbstractCell(AbstractColumn<?> column) {
            this.columnComponent = column;
        }

        protected void setColumn(AbstractColumn<?> column) {
            this.columnComponent = column;
        }

        protected AbstractColumn<?> getColumn() {
            return this.columnComponent;
        }

        public abstract void setText(String var1);

        public abstract void setComponent(Component var1);
    }
}

