/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.gridpro;

import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.gridpro.EditorType;
import com.vaadin.flow.component.gridpro.GridPro;
import com.vaadin.flow.component.gridpro.ItemUpdater;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class EditColumnConfigurator<T>
implements Serializable {
    private final GridPro.EditColumn<T> column;
    private Registration attachRegistration;
    private boolean editModeRendererRequested = false;

    EditColumnConfigurator(GridPro.EditColumn<T> column, ValueProvider<T, ?> valueProvider) {
        assert (column != null);
        this.column = column;
        this.column.setValueProvider(valueProvider);
    }

    private Grid.Column<T> configureColumn(ItemUpdater<T, String> itemUpdater, EditorType type, List<String> options) {
        this.column.setEditorType(type);
        this.column.setItemUpdater(itemUpdater);
        this.column.setOptions(options);
        this.column.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.column, (SerializableConsumer & Serializable)context -> UI.getCurrent().getPage().executeJs("window.Vaadin.Flow.gridProConnector.patchEditModeRenderer($0)", new Serializable[]{this.column.getElement()})));
        return this.getColumn();
    }

    private <V> Grid.Column<T> configureColumn(ValueProvider<T, V> valueProvider, ItemUpdater<T, String> itemUpdater, EditorType type, HasValueAndElement<?, V> editorField) {
        this.column.setEditorType(type);
        this.column.setItemUpdater(itemUpdater);
        this.column.setEditorField(editorField);
        this.column.setValueProvider(valueProvider);
        return this.getColumn();
    }

    public Grid.Column<T> getColumn() {
        return this.column;
    }

    public Grid.Column<T> text(ItemUpdater<T, String> itemUpdater) {
        return this.configureColumn(itemUpdater, EditorType.TEXT, Collections.emptyList());
    }

    public <V> Grid.Column<T> custom(HasValueAndElement<?, V> component, ItemUpdater<T, V> itemUpdater) {
        ValueProvider<T, ?> valueProvider = this.column.getValueProvider();
        return this.custom(component, valueProvider, itemUpdater);
    }

    public <V> Grid.Column<T> custom(HasValueAndElement<?, V> component, ValueProvider<T, V> valueProvider, ItemUpdater<T, V> itemUpdater) {
        this.column.getElement().appendVirtualChild(new Element[]{component.getElement()});
        if (this.attachRegistration != null) {
            this.attachRegistration.remove();
            this.attachRegistration = null;
        }
        this.attachRegistration = this.column.getElement().addAttachListener((ElementAttachListener & Serializable)e -> this.setEditModeRenderer(component));
        this.setEditModeRenderer(component);
        return this.configureColumn(valueProvider, (ItemUpdater<Object, String> & Serializable)(item, ignore) -> itemUpdater.accept(item, component.getValue()), EditorType.CUSTOM, component);
    }

    private <V> void setEditModeRenderer(HasValueAndElement<?, V> component) {
        if (this.editModeRendererRequested) {
            return;
        }
        this.editModeRendererRequested = true;
        this.column.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.column, (SerializableConsumer & Serializable)context -> {
            if (!this.editModeRendererRequested) {
                return;
            }
            ui.getPage().executeJs("window.Vaadin.Flow.gridProConnector.setEditModeRenderer($0, $1)", new Serializable[]{this.column.getElement(), component.getElement()});
            this.editModeRendererRequested = false;
        }));
    }

    public Grid.Column<T> checkbox(ItemUpdater<T, Boolean> itemUpdater) {
        ItemUpdater<Object, String> & Serializable wrapper = (ItemUpdater<Object, String> & Serializable)(item, value) -> itemUpdater.accept(item, Boolean.valueOf(value));
        return this.configureColumn(wrapper, EditorType.CHECKBOX, Collections.emptyList());
    }

    public Grid.Column<T> select(ItemUpdater<T, String> itemUpdater, List<String> options) {
        Objects.requireNonNull(options);
        return this.configureColumn(itemUpdater, EditorType.SELECT, options);
    }

    public Grid.Column<T> select(ItemUpdater<T, String> itemUpdater, String ... options) {
        return this.select(itemUpdater, Arrays.asList(options));
    }

    public <E extends Enum<E>> Grid.Column<T> select(ItemUpdater<T, E> itemUpdater, Class<E> enumType, SerializableFunction<E, String> getStringRepresentation) {
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        Enum[] items = (Enum[])enumType.getEnumConstants();
        ArrayList<String> itemsList = new ArrayList<String>();
        for (Enum item2 : items) {
            String stringRepresentation = (String)getStringRepresentation.apply((Object)item2);
            if (map.containsKey(stringRepresentation)) {
                throw new IllegalArgumentException("Enum constants " + map.get(stringRepresentation) + " and " + item2 + " both have the same string representation: " + stringRepresentation);
            }
            map.put(stringRepresentation, item2);
            itemsList.add(stringRepresentation);
        }
        ItemUpdater<Object, String> & Serializable wrapper = (ItemUpdater<Object, String> & Serializable)(item, value) -> itemUpdater.accept(item, (Enum)map.get(value));
        return this.select(wrapper, itemsList);
    }

    public <E extends Enum<E>> Grid.Column<T> select(ItemUpdater<T, E> itemUpdater, Class<E> enumType) {
        return this.select(itemUpdater, enumType, Object::toString);
    }

    public EditColumnConfigurator<T> withManualRefresh() {
        this.column.setManualRefresh(true);
        return this;
    }

    public EditColumnConfigurator<T> withCellEditableProvider(SerializablePredicate<T> cellEditableProvider) {
        this.column.setCellEditableProvider(cellEditableProvider);
        return this;
    }
}

