/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.component.map.configuration.AbstractConfigurationObject;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.Extent;
import com.vaadin.flow.component.map.configuration.Projection;
import java.util.Objects;

public class View
extends AbstractConfigurationObject {
    private Coordinate center = new Coordinate(0.0, 0.0);
    private double rotation = 0.0;
    private double zoom = 0.0;
    private Extent extent = new Extent(0.0, 0.0, 0.0, 0.0);
    private final String projection;

    public View() {
        this(Projection.EPSG_3857.stringValue());
    }

    public View(String projection) {
        this.projection = projection;
    }

    @Override
    public String getType() {
        return "ol/View";
    }

    public Coordinate getCenter() {
        return this.center;
    }

    public void setCenter(Coordinate center) {
        Objects.requireNonNull(center, "Center cannot be null");
        this.center = center;
        this.markAsDirty();
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
        this.markAsDirty();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
        this.markAsDirty();
    }

    public String getProjection() {
        return this.projection;
    }

    @JsonIgnore
    public Extent getExtent() {
        return this.extent;
    }

    public void updateInternalViewState(Coordinate center, double rotation, double zoom, Extent extent) {
        this.update(() -> {
            this.center = center;
            this.rotation = rotation;
            this.zoom = zoom;
            this.extent = extent;
        }, false);
    }
}

