/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.scopes;

import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.spring.SpringVaadinSession;
import com.vaadin.flow.spring.scopes.AbstractScope;
import com.vaadin.flow.spring.scopes.BeanStore;
import java.io.Serializable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;

public class VaadinSessionScope
extends AbstractScope {
    public static final String VAADIN_SESSION_SCOPE_NAME = "vaadin-session";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope(VAADIN_SESSION_SCOPE_NAME, (Scope)this);
        ObjectFactory factory = this::getVaadinSession;
        beanFactory.registerResolvableDependency(VaadinSession.class, (Object)factory);
    }

    public String getConversationId() {
        return this.getVaadinSession().getSession().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BeanStore getBeanStore() {
        VaadinSession session = this.getVaadinSession();
        session.lock();
        try {
            BeanStore beanStore = (BeanStore)session.getAttribute(BeanStore.class);
            if (beanStore == null) {
                beanStore = new SessionBeanStore(session);
                session.setAttribute(BeanStore.class, (Object)beanStore);
            }
            BeanStore beanStore2 = beanStore;
            return beanStore2;
        }
        finally {
            session.unlock();
        }
    }

    private static class SessionBeanStore
    extends BeanStore {
        private final Registration sessionDestroyListenerRegistration;

        private SessionBeanStore(VaadinSession session) {
            super(session);
            if (session instanceof SpringVaadinSession) {
                this.sessionDestroyListenerRegistration = null;
                ((SpringVaadinSession)session).addDestroyListener((SessionDestroyListener & Serializable)event -> this.destroy());
            } else {
                this.sessionDestroyListenerRegistration = session.getService().addSessionDestroyListener((SessionDestroyListener & Serializable)event -> this.destroy());
            }
        }

        @Override
        Void doDestroy() {
            try {
                this.getVaadinSession().setAttribute(BeanStore.class, null);
                super.doDestroy();
            }
            finally {
                if (this.sessionDestroyListenerRegistration != null) {
                    this.sessionDestroyListenerRegistration.remove();
                }
            }
            return null;
        }
    }
}

