/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TEnum;

public enum PropertyType implements TEnum
{
    UNKNOWN(0),
    BOOL(1),
    INT64(2),
    VID(3),
    FLOAT(4),
    DOUBLE(5),
    STRING(6),
    FIXED_STRING(7),
    INT8(8),
    INT16(9),
    INT32(10),
    TIMESTAMP(21),
    DURATION(23),
    DATE(24),
    DATETIME(25),
    TIME(26),
    GEOGRAPHY(31);

    private static final Map<Integer, PropertyType> INDEXED_VALUES;
    private final int value;

    private PropertyType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static PropertyType findByValue(int value) {
        return INDEXED_VALUES.get(value);
    }

    static {
        INDEXED_VALUES = new HashMap<Integer, PropertyType>();
        for (PropertyType e : PropertyType.values()) {
            INDEXED_VALUES.put(e.getValue(), e);
        }
    }
}

