/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.meta;

import com.vesoft.nebula.client.graph.data.HostAddress;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.THeaderProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.THeaderTransport;
import org.apache.flink.connector.nebula.shaded.com.google.common.base.Preconditions;
import org.apache.flink.connector.nebula.shaded.com.google.common.net.InetAddresses;
import org.apache.flink.connector.nebula.shaded.com.google.common.net.InternetDomainName;

public class AbstractMetaClient
implements Serializable {
    protected final List<HostAddress> addresses;
    protected final int connectionRetry;
    protected final int executionRetry;
    protected final int timeout;
    protected THeaderProtocol protocol;
    protected THeaderTransport transport;

    public AbstractMetaClient(List<HostAddress> addresses, int timeout, int connectionRetry, int executionRetry) throws UnknownHostException {
        Preconditions.checkArgument(timeout > 0);
        Preconditions.checkArgument(connectionRetry >= 0);
        Preconditions.checkArgument(executionRetry >= 0);
        for (HostAddress address : addresses) {
            String host = InetAddress.getByName(address.getHost()).getHostAddress();
            int port = address.getPort();
            if ((InetAddresses.isInetAddress(host) || InetAddresses.isUriInetAddress(host) || InternetDomainName.isValid(host)) && port > 0 && port < 65535) continue;
            throw new IllegalArgumentException(String.format("%s:%d is not a valid address", host, port));
        }
        this.addresses = addresses;
        this.timeout = timeout;
        this.connectionRetry = connectionRetry;
        this.executionRetry = executionRetry;
    }

    public int getConnectionRetry() {
        return this.connectionRetry;
    }

    public int getExecutionRetry() {
        return this.executionRetry;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

