/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.storage.GraphStorageConnection;
import com.vesoft.nebula.client.storage.StoragePoolConfig;
import java.io.Serializable;
import org.apache.flink.connector.nebula.shaded.org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.flink.connector.nebula.shaded.org.apache.commons.pool2.PooledObject;
import org.apache.flink.connector.nebula.shaded.org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.flink.connector.nebula.shaded.org.slf4j.Logger;
import org.apache.flink.connector.nebula.shaded.org.slf4j.LoggerFactory;

public class StorageConnPoolFactory
implements KeyedPooledObjectFactory<HostAddress, GraphStorageConnection>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageConnPoolFactory.class);
    private final StoragePoolConfig config;

    public StorageConnPoolFactory(StoragePoolConfig config) {
        this.config = config;
    }

    @Override
    public PooledObject<GraphStorageConnection> makeObject(HostAddress address) throws Exception {
        GraphStorageConnection connection = new GraphStorageConnection();
        return new DefaultPooledObject<GraphStorageConnection>(connection);
    }

    @Override
    public void destroyObject(HostAddress hostAndPort, PooledObject<GraphStorageConnection> pooledObject) {
        pooledObject.getObject().close();
    }

    @Override
    public boolean validateObject(HostAddress hostAndPort, PooledObject<GraphStorageConnection> pooledObject) {
        GraphStorageConnection connection = pooledObject.getObject();
        if (connection == null) {
            return false;
        }
        try {
            return connection.transport.isOpen();
        }
        catch (Exception e) {
            LOGGER.warn(String.format("storage connection with %s:%d is not open", hostAndPort.getHost(), hostAndPort.getPort()), e);
            return false;
        }
    }

    @Override
    public void activateObject(HostAddress address, PooledObject<GraphStorageConnection> pooledObject) throws Exception {
        pooledObject.getObject().open(address, this.config.getTimeout(), this.config.isEnableSSL(), this.config.getSslParam());
    }

    @Override
    public void passivateObject(HostAddress hostAndPort, PooledObject<GraphStorageConnection> pooledObject) {
        pooledObject.markReturning();
    }
}

