/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.vesoft.nebula.HostAddr;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.StructMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class VerifyClientVersionReq
implements TBase,
Serializable,
Cloneable,
Comparable<VerifyClientVersionReq> {
    private static final TStruct STRUCT_DESC = new TStruct("VerifyClientVersionReq");
    private static final TField CLIENT_VERSION_FIELD_DESC = new TField("client_version", 11, 1);
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 2);
    private static final TField BUILD_VERSION_FIELD_DESC = new TField("build_version", 11, 3);
    public byte[] client_version;
    public HostAddr host;
    public byte[] build_version;
    public static final int CLIENT_VERSION = 1;
    public static final int HOST = 2;
    public static final int BUILD_VERSION = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public VerifyClientVersionReq() {
        this.client_version = "3.0.0".getBytes();
    }

    public VerifyClientVersionReq(byte[] client_version) {
        this();
        this.client_version = client_version;
    }

    public VerifyClientVersionReq(byte[] client_version, HostAddr host, byte[] build_version) {
        this();
        this.client_version = client_version;
        this.host = host;
        this.build_version = build_version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerifyClientVersionReq(VerifyClientVersionReq other) {
        if (other.isSetClient_version()) {
            this.client_version = TBaseHelper.deepCopy(other.client_version);
        }
        if (other.isSetHost()) {
            this.host = TBaseHelper.deepCopy(other.host);
        }
        if (other.isSetBuild_version()) {
            this.build_version = TBaseHelper.deepCopy(other.build_version);
        }
    }

    @Override
    public VerifyClientVersionReq deepCopy() {
        return new VerifyClientVersionReq(this);
    }

    public byte[] getClient_version() {
        return this.client_version;
    }

    public VerifyClientVersionReq setClient_version(byte[] client_version) {
        this.client_version = client_version;
        return this;
    }

    public void unsetClient_version() {
        this.client_version = null;
    }

    public boolean isSetClient_version() {
        return this.client_version != null;
    }

    public void setClient_versionIsSet(boolean __value) {
        if (!__value) {
            this.client_version = null;
        }
    }

    public HostAddr getHost() {
        return this.host;
    }

    public VerifyClientVersionReq setHost(HostAddr host) {
        this.host = host;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean __value) {
        if (!__value) {
            this.host = null;
        }
    }

    public byte[] getBuild_version() {
        return this.build_version;
    }

    public VerifyClientVersionReq setBuild_version(byte[] build_version) {
        this.build_version = build_version;
        return this;
    }

    public void unsetBuild_version() {
        this.build_version = null;
    }

    public boolean isSetBuild_version() {
        return this.build_version != null;
    }

    public void setBuild_versionIsSet(boolean __value) {
        if (!__value) {
            this.build_version = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetClient_version();
                    break;
                }
                this.setClient_version((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetBuild_version();
                    break;
                }
                this.setBuild_version((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getClient_version();
            }
            case 2: {
                return this.getHost();
            }
            case 3: {
                return this.getBuild_version();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof VerifyClientVersionReq)) {
            return false;
        }
        VerifyClientVersionReq that = (VerifyClientVersionReq)_that;
        if (!TBaseHelper.equalsSlow(this.isSetClient_version(), that.isSetClient_version(), this.client_version, that.client_version)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetHost(), that.isSetHost(), this.host, that.host)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetBuild_version(), that.isSetBuild_version(), this.build_version, that.build_version);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.client_version, this.host, this.build_version});
    }

    @Override
    public int compareTo(VerifyClientVersionReq other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetClient_version()).compareTo(other.isSetClient_version());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.client_version, other.client_version);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHost()).compareTo(other.isSetHost());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBuild_version()).compareTo(other.isSetBuild_version());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.build_version, other.build_version);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.client_version = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.host = new HostAddr();
                        this.host.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 11) {
                        this.build_version = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.client_version != null) {
            oprot.writeFieldBegin(CLIENT_VERSION_FIELD_DESC);
            oprot.writeBinary(this.client_version);
            oprot.writeFieldEnd();
        }
        if (this.host != null) {
            oprot.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.build_version != null) {
            oprot.writeFieldBegin(BUILD_VERSION_FIELD_DESC);
            oprot.writeBinary(this.build_version);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("VerifyClientVersionReq");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("client_version");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getClient_version() == null) {
            sb.append("null");
        } else {
            int __client_version_size = Math.min(this.getClient_version().length, 128);
            for (i = 0; i < __client_version_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getClient_version()[i]).length() > 1 ? Integer.toHexString(this.getClient_version()[i]).substring(Integer.toHexString(this.getClient_version()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getClient_version()[i]).toUpperCase());
            }
            if (this.getClient_version().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("host");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("build_version");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getBuild_version() == null) {
            sb.append("null");
        } else {
            int __build_version_size = Math.min(this.getBuild_version().length, 128);
            for (i = 0; i < __build_version_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getBuild_version()[i]).length() > 1 ? Integer.toHexString(this.getBuild_version()[i]).substring(Integer.toHexString(this.getBuild_version()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getBuild_version()[i]).toUpperCase());
            }
            if (this.getBuild_version().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.client_version == null) {
            throw new TProtocolException(6, "Required field 'client_version' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("client_version", 1, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("host", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("build_version", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(VerifyClientVersionReq.class, metaDataMap);
    }

    public static class Builder {
        private byte[] client_version;
        private HostAddr host;
        private byte[] build_version;

        public Builder setClient_version(byte[] client_version) {
            this.client_version = client_version;
            return this;
        }

        public Builder setHost(HostAddr host) {
            this.host = host;
            return this;
        }

        public Builder setBuild_version(byte[] build_version) {
            this.build_version = build_version;
            return this;
        }

        public VerifyClientVersionReq build() {
            VerifyClientVersionReq result = new VerifyClientVersionReq();
            result.setClient_version(this.client_version);
            result.setHost(this.host);
            result.setBuild_version(this.build_version);
            return result;
        }
    }
}

