/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.StructMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class PartitionResult
implements TBase,
Serializable,
Cloneable,
Comparable<PartitionResult> {
    private static final TStruct STRUCT_DESC = new TStruct("PartitionResult");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField PART_ID_FIELD_DESC = new TField("part_id", 8, 2);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 3);
    public ErrorCode code;
    public int part_id;
    public HostAddr leader;
    public static final int CODE = 1;
    public static final int PART_ID = 2;
    public static final int LEADER = 3;
    private static final int __PART_ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public PartitionResult() {
    }

    public PartitionResult(ErrorCode code, int part_id) {
        this();
        this.code = code;
        this.part_id = part_id;
        this.setPart_idIsSet(true);
    }

    public PartitionResult(ErrorCode code, int part_id, HostAddr leader) {
        this();
        this.code = code;
        this.part_id = part_id;
        this.setPart_idIsSet(true);
        this.leader = leader;
    }

    public static Builder builder() {
        return new Builder();
    }

    public PartitionResult(PartitionResult other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        this.part_id = TBaseHelper.deepCopy(other.part_id);
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
    }

    @Override
    public PartitionResult deepCopy() {
        return new PartitionResult(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public PartitionResult setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public int getPart_id() {
        return this.part_id;
    }

    public PartitionResult setPart_id(int part_id) {
        this.part_id = part_id;
        this.setPart_idIsSet(true);
        return this;
    }

    public void unsetPart_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetPart_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setPart_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public PartitionResult setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetPart_id();
                    break;
                }
                this.setPart_id((Integer)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return new Integer(this.getPart_id());
            }
            case 3: {
                return this.getLeader();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof PartitionResult)) {
            return false;
        }
        PartitionResult that = (PartitionResult)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.part_id, that.part_id)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.part_id, this.leader});
    }

    @Override
    public int compareTo(PartitionResult other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPart_id()).compareTo(other.isSetPart_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.part_id, other.part_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 8) {
                        this.part_id = iprot.readI32();
                        this.setPart_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        if (!this.isSetPart_id()) {
            throw new TProtocolException("Required field 'part_id' was not found in serialized data! Struct: " + this.toString());
        }
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(PART_ID_FIELD_DESC);
        oprot.writeI32(this.part_id);
        oprot.writeFieldEnd();
        if (this.leader != null && this.isSetLeader()) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("PartitionResult");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("part_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getPart_id(), indent + 1, prettyPrint));
        first = false;
        if (this.isSetLeader()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("leader");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getLeader() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.code == null) {
            throw new TProtocolException(6, "Required field 'code' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 1, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("part_id", 1, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("leader", 2, new StructMetaData(12, HostAddr.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(PartitionResult.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private int part_id;
        private HostAddr leader;
        BitSet __optional_isset = new BitSet(1);

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setPart_id(int part_id) {
            this.part_id = part_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public PartitionResult build() {
            PartitionResult result = new PartitionResult();
            result.setCode(this.code);
            if (this.__optional_isset.get(0)) {
                result.setPart_id(this.part_id);
            }
            result.setLeader(this.leader);
            return result;
        }
    }
}

