/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.connection;

import com.vesoft.nebula.client.graph.data.HostAddress;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.nebula.connection.CASignParams;
import org.apache.flink.connector.nebula.connection.SelfSignParams;
import org.apache.flink.connector.nebula.utils.NebulaConstant;
import org.apache.flink.connector.nebula.utils.SSLSignType;

public class NebulaClientOptions
implements Serializable {
    private static final long serialVersionUID = 5685521189643221375L;
    private final String metaAddress;
    private final String graphAddress;
    private final String username;
    private final String password;
    private final int timeout;
    private final int connectRetry;
    private final boolean enableGraphSSL;
    private final boolean enableMetaSSL;
    private final boolean enableStorageSSL;
    private final SSLSignType sslSignType;
    private final CASignParams caSignParams;
    private final SelfSignParams selfSignParams;

    private NebulaClientOptions(String metaAddress, String graphAddress, String username, String password, int timeout, int connectRetry, boolean enableGraphSSL, boolean enableMetaSSL, boolean enableStorageSSL, SSLSignType sslSignType, CASignParams caSignParams, SelfSignParams selfSignParams) {
        this.metaAddress = metaAddress;
        this.graphAddress = graphAddress;
        this.username = username;
        this.password = password;
        this.timeout = timeout;
        this.connectRetry = connectRetry;
        this.enableGraphSSL = enableGraphSSL;
        this.enableMetaSSL = enableMetaSSL;
        this.enableStorageSSL = enableStorageSSL;
        this.sslSignType = sslSignType;
        this.caSignParams = caSignParams;
        this.selfSignParams = selfSignParams;
    }

    public List<HostAddress> getMetaAddress() {
        ArrayList<HostAddress> addresses = new ArrayList<HostAddress>();
        for (String address : this.metaAddress.split(NebulaConstant.COMMA)) {
            String[] hostAndPort = address.split(NebulaConstant.COLON);
            addresses.add(new HostAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        return addresses;
    }

    public String getRawMetaAddress() {
        return this.metaAddress;
    }

    public String getGraphAddress() {
        return this.graphAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getConnectRetry() {
        return this.connectRetry;
    }

    public boolean isEnableGraphSSL() {
        return this.enableGraphSSL;
    }

    public boolean isEnableMetaSSL() {
        return this.enableMetaSSL;
    }

    public boolean isEnableStorageSSL() {
        return this.enableStorageSSL;
    }

    public SSLSignType getSSLSignType() {
        return this.sslSignType;
    }

    public CASignParams getCaSignParam() {
        return this.caSignParams;
    }

    public SelfSignParams getSelfSignParam() {
        return this.selfSignParams;
    }

    public static class NebulaClientOptionsBuilder {
        private String metaAddress;
        private String graphAddress;
        private String username = "root";
        private String password = "nebula";
        private int timeout = 6000;
        private int connectRetry = 1;
        private boolean enableGraphSSL = false;
        private boolean enableMetaSSL = false;
        private boolean enableStorageSSL = false;
        private SSLSignType sslSignType = null;
        private CASignParams caSignParams = null;
        private SelfSignParams selfSignParams = null;

        public NebulaClientOptionsBuilder setMetaAddress(String metaAddress) {
            this.metaAddress = metaAddress;
            return this;
        }

        public NebulaClientOptionsBuilder setGraphAddress(String graphAddress) {
            this.graphAddress = graphAddress;
            return this;
        }

        public NebulaClientOptionsBuilder setUsername(String username) {
            this.username = username;
            return this;
        }

        public NebulaClientOptionsBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public NebulaClientOptionsBuilder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public NebulaClientOptionsBuilder setConnectRetry(int connectRetry) {
            this.connectRetry = connectRetry;
            return this;
        }

        public NebulaClientOptionsBuilder setEnableGraphSSL(boolean enableGraphSSL) {
            this.enableGraphSSL = enableGraphSSL;
            return this;
        }

        public NebulaClientOptionsBuilder setEnableMetaSSL(boolean enableMetaSSL) {
            this.enableMetaSSL = enableMetaSSL;
            return this;
        }

        public NebulaClientOptionsBuilder setEnableStorageSSL(boolean enableStorageSSL) {
            this.enableStorageSSL = enableStorageSSL;
            return this;
        }

        public NebulaClientOptionsBuilder setSSLSignType(SSLSignType sslSignType) {
            this.sslSignType = sslSignType;
            return this;
        }

        public NebulaClientOptionsBuilder setCaSignParam(String caCrtFilePath, String crtFilePath, String keyFilePath) {
            this.caSignParams = new CASignParams(caCrtFilePath, crtFilePath, keyFilePath);
            return this;
        }

        public NebulaClientOptionsBuilder setSelfSignParam(String crtFilePath, String keyFilePath, String password) {
            this.selfSignParams = new SelfSignParams(crtFilePath, keyFilePath, password);
            return this;
        }

        public NebulaClientOptions build() {
            if (this.metaAddress == null || this.metaAddress.trim().isEmpty()) {
                throw new IllegalArgumentException("meta address can not be empty.");
            }
            if (this.enableMetaSSL || this.enableGraphSSL || this.enableStorageSSL) {
                if (this.enableStorageSSL && !this.enableMetaSSL) {
                    throw new IllegalArgumentException("storage ssl is enabled, meta ssl must be enabled.");
                }
                if (this.sslSignType == null) {
                    throw new IllegalArgumentException("ssl is enabled, ssl sign type must not be null");
                }
                switch (this.sslSignType) {
                    case CA: {
                        if (this.caSignParams != null) break;
                        throw new IllegalArgumentException("ssl is enabled and sign type is CA, caSignParam must not be null");
                    }
                    case SELF: {
                        if (this.selfSignParams != null) break;
                        throw new IllegalArgumentException("ssl is enabled and sign type is SELF, selfSignParam must not be null");
                    }
                    default: {
                        throw new IllegalArgumentException("ssl sign type is not supported.");
                    }
                }
            }
            return new NebulaClientOptions(this.metaAddress, this.graphAddress, this.username, this.password, this.timeout, this.connectRetry, this.enableGraphSSL, this.enableMetaSSL, this.enableStorageSSL, this.sslSignType, this.caSignParams, this.selfSignParams);
        }
    }
}

