/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.connection;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import com.vesoft.nebula.client.graph.data.CASignedSSLParam;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.SSLParam;
import com.vesoft.nebula.client.graph.data.SelfSignedSSLParam;
import com.vesoft.nebula.client.graph.net.NebulaPool;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.connector.nebula.connection.CASignParams;
import org.apache.flink.connector.nebula.connection.NebulaClientOptions;
import org.apache.flink.connector.nebula.connection.SelfSignParams;
import org.apache.flink.connector.nebula.shaded.org.slf4j.Logger;
import org.apache.flink.connector.nebula.shaded.org.slf4j.LoggerFactory;
import org.apache.flink.connector.nebula.utils.NebulaConstant;

public class NebulaGraphConnectionProvider
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(NebulaGraphConnectionProvider.class);
    private static final long serialVersionUID = 8392002706492085208L;
    private final NebulaClientOptions nebulaClientOptions;

    public NebulaGraphConnectionProvider(NebulaClientOptions nebulaClientOptions) {
        this.nebulaClientOptions = nebulaClientOptions;
    }

    public NebulaPool getNebulaPool() throws UnknownHostException {
        ArrayList<HostAddress> addresses = new ArrayList<HostAddress>();
        for (String address : this.nebulaClientOptions.getGraphAddress().split(NebulaConstant.COMMA)) {
            String[] hostAndPort = address.split(NebulaConstant.COLON);
            addresses.add(new HostAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        Collections.shuffle(addresses);
        NebulaPool nebulaPool = new NebulaPool();
        NebulaPoolConfig poolConfig = new NebulaPoolConfig();
        poolConfig.setTimeout(this.nebulaClientOptions.getTimeout());
        if (this.nebulaClientOptions.isEnableGraphSSL()) {
            poolConfig.setEnableSsl(true);
            switch (this.nebulaClientOptions.getSSLSignType()) {
                case CA: {
                    CASignParams caSignParams = this.nebulaClientOptions.getCaSignParam();
                    SSLParam sslParam = new CASignedSSLParam(caSignParams.getCaCrtFilePath(), caSignParams.getCrtFilePath(), caSignParams.getKeyFilePath());
                    poolConfig.setSslParam(sslParam);
                    break;
                }
                case SELF: {
                    SelfSignParams selfSignParams = this.nebulaClientOptions.getSelfSignParam();
                    SSLParam sslParam = new SelfSignedSSLParam(selfSignParams.getCrtFilePath(), selfSignParams.getKeyFilePath(), selfSignParams.getPassword());
                    poolConfig.setSslParam(sslParam);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ssl sign type is not supported.");
                }
            }
        }
        nebulaPool.init(addresses, poolConfig);
        return nebulaPool;
    }

    public String getUserName() {
        return this.nebulaClientOptions.getUsername();
    }

    public String getPassword() {
        return this.nebulaClientOptions.getPassword();
    }
}

