/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.connection;

import com.vesoft.nebula.PropertyType;
import com.vesoft.nebula.client.graph.data.CASignedSSLParam;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.SelfSignedSSLParam;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.meta.MetaClient;
import com.vesoft.nebula.client.meta.exception.ExecuteFailedException;
import com.vesoft.nebula.meta.ColumnDef;
import com.vesoft.nebula.meta.Schema;
import com.vesoft.nebula.meta.SpaceItem;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.nebula.connection.CASignParams;
import org.apache.flink.connector.nebula.connection.NebulaClientOptions;
import org.apache.flink.connector.nebula.connection.SelfSignParams;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.org.slf4j.Logger;
import org.apache.flink.connector.nebula.shaded.org.slf4j.LoggerFactory;
import org.apache.flink.connector.nebula.utils.VidTypeEnum;

public class NebulaMetaConnectionProvider
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(NebulaMetaConnectionProvider.class);
    private static final long serialVersionUID = -1045337416133033961L;
    private final NebulaClientOptions nebulaClientOptions;

    public NebulaMetaConnectionProvider(NebulaClientOptions nebulaClientOptions) {
        this.nebulaClientOptions = nebulaClientOptions;
    }

    public MetaClient getMetaClient() throws TException, ClientServerIncompatibleException, UnknownHostException {
        MetaClient metaClient;
        block5: {
            int retry;
            int timeout;
            List<HostAddress> addresses;
            block4: {
                addresses = this.nebulaClientOptions.getMetaAddress();
                timeout = this.nebulaClientOptions.getTimeout();
                retry = this.nebulaClientOptions.getConnectRetry();
                if (!this.nebulaClientOptions.isEnableMetaSSL()) break block4;
                switch (this.nebulaClientOptions.getSSLSignType()) {
                    case CA: {
                        CASignParams caSignParams = this.nebulaClientOptions.getCaSignParam();
                        CASignedSSLParam sslParam = new CASignedSSLParam(caSignParams.getCaCrtFilePath(), caSignParams.getCrtFilePath(), caSignParams.getKeyFilePath());
                        metaClient = new MetaClient(addresses, timeout, retry, retry, true, sslParam);
                        break block5;
                    }
                    case SELF: {
                        SelfSignParams selfSignParams = this.nebulaClientOptions.getSelfSignParam();
                        SelfSignedSSLParam sslParam = new SelfSignedSSLParam(selfSignParams.getCrtFilePath(), selfSignParams.getKeyFilePath(), selfSignParams.getPassword());
                        metaClient = new MetaClient(addresses, timeout, retry, retry, true, sslParam);
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException("ssl sign type is not supported.");
                    }
                }
            }
            metaClient = new MetaClient(addresses, timeout, retry, retry);
        }
        metaClient.connect();
        return metaClient;
    }

    public VidTypeEnum getVidType(MetaClient metaClient, String space) {
        SpaceItem spaceItem;
        try {
            spaceItem = metaClient.getSpace(space);
        }
        catch (ExecuteFailedException | TException e) {
            LOG.error("get space info error, ", e);
            throw new RuntimeException(e);
        }
        PropertyType vidType = spaceItem.getProperties().getVid_type().getType();
        if (vidType == PropertyType.FIXED_STRING) {
            return VidTypeEnum.STRING;
        }
        return VidTypeEnum.INT;
    }

    public Map<String, Integer> getTagSchema(MetaClient metaClient, String space, String tag) {
        Schema tagSchema;
        HashMap<String, Integer> schema = new HashMap<String, Integer>();
        try {
            tagSchema = metaClient.getTag(space, tag);
        }
        catch (ExecuteFailedException | TException e) {
            LOG.error("get tag schema error, ", e);
            throw new RuntimeException(e);
        }
        List<ColumnDef> columnDefs = tagSchema.getColumns();
        for (ColumnDef col : columnDefs) {
            schema.put(new String(col.getName()), col.getType().getType().getValue());
        }
        return schema;
    }

    public Map<String, Integer> getEdgeSchema(MetaClient metaClient, String space, String edge) {
        Schema edgeSchema;
        HashMap<String, Integer> schema = new HashMap<String, Integer>();
        try {
            edgeSchema = metaClient.getEdge(space, edge);
        }
        catch (ExecuteFailedException | TException e) {
            LOG.error("get edge schema error, ", e);
            throw new RuntimeException(e);
        }
        List<ColumnDef> columnDefs = edgeSchema.getColumns();
        for (ColumnDef col : columnDefs) {
            schema.put(new String(col.getName()), col.getType().getType().getValue());
        }
        return schema;
    }
}

