/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TIOStreamTransport;

public class TDeserializeUtils {
    public static TProtocol protocolFromByteArray(TProtocolFactory protocolFactory, byte[] bytes) throws TException {
        return protocolFactory.getProtocol(new TIOStreamTransport(new ByteArrayInputStream(bytes)));
    }

    public static TProtocol protocolFromByteBuffer(TProtocolFactory protocolFactory, ByteBuffer buffer) throws TException {
        byte[] byteData = new byte[buffer.limit()];
        buffer.position(0);
        buffer.get(byteData);
        return TDeserializeUtils.protocolFromByteArray(protocolFactory, byteData);
    }

    public static TProtocol protocolFromString(TProtocolFactory protocolFactory, String data, String charset) throws TException {
        try {
            return TDeserializeUtils.protocolFromByteArray(protocolFactory, data.getBytes(charset));
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
    }

    public static TProtocol protocolFromString(TProtocolFactory protocolFactory, String data) throws TException {
        return TDeserializeUtils.protocolFromByteArray(protocolFactory, data.getBytes());
    }
}

