/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol;

import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TJSONProtocolBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TList;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TMap;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TSet;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TTransport;

public class TJSONProtocol
extends TJSONProtocolBase {
    public TJSONProtocol(TTransport trans) {
        super(trans);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        this.writeJSONObjectStart();
    }

    @Override
    public void writeStructEnd() throws TException {
        this.writeJSONObjectEnd();
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        this.writeJSONInteger(field.id);
        this.writeJSONObjectStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(field.type));
    }

    @Override
    public void writeFieldEnd() throws TException {
        this.writeJSONObjectEnd();
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(map.keyType));
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(map.valueType));
        this.writeJSONInteger(map.size);
        this.writeJSONObjectStart();
    }

    @Override
    public void writeMapEnd() throws TException {
        this.writeJSONObjectEnd();
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(list.elemType));
        this.writeJSONInteger(list.size);
    }

    @Override
    public void writeListEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(set.elemType));
        this.writeJSONInteger(set.size);
    }

    @Override
    public void writeSetEnd() throws TException {
        this.writeJSONArrayEnd();
    }

    @Override
    public TStruct readStructBegin(Map<Integer, FieldMetaData> metaDataMap) throws TException {
        this.readJSONObjectStart();
        return ANONYMOUS_STRUCT;
    }

    @Override
    public void readStructEnd() throws TException {
        this.readJSONObjectEnd();
    }

    @Override
    public TField readFieldBegin() throws TException {
        byte type;
        byte ch = this.reader_.peek();
        short id = 0;
        if (ch == RBRACE[0]) {
            type = 0;
        } else {
            id = (short)this.readJSONInteger();
            this.readJSONObjectStart();
            type = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        }
        return new TField("", type, id);
    }

    @Override
    public void readFieldEnd() throws TException {
        this.readJSONObjectEnd();
    }

    @Override
    public TMap readMapBegin() throws TException {
        this.readJSONArrayStart();
        byte keyType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        byte valueType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        this.readJSONObjectStart();
        return new TMap(keyType, valueType, size);
    }

    @Override
    public void readMapEnd() throws TException {
        this.readJSONObjectEnd();
        this.readJSONArrayEnd();
    }

    @Override
    public TList readListBegin() throws TException {
        this.readJSONArrayStart();
        byte elemType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        return new TList(elemType, size);
    }

    @Override
    public void readListEnd() throws TException {
        this.readJSONArrayEnd();
    }

    @Override
    public TSet readSetBegin() throws TException {
        this.readJSONArrayStart();
        byte elemType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        return new TSet(elemType, size);
    }

    @Override
    public void readSetEnd() throws TException {
        this.readJSONArrayEnd();
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TJSONProtocol(trans);
        }
    }
}

