/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TNonblockingTransport;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TSocketIf;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TTransportException;

public class TNonblockingSocket
extends TNonblockingTransport
implements TSocketIf {
    private final SocketAddress socketAddress;
    private SocketChannel socketChannel = null;
    private Socket socket_ = null;
    private int timeout_ = 0;

    public TNonblockingSocket(String host, int port) throws TTransportException, IOException {
        this(host, port, 0);
    }

    public TNonblockingSocket(String host, int port, int timeout) throws TTransportException, IOException {
        this(SocketChannel.open(), timeout, new InetSocketAddress(host, port));
    }

    public TNonblockingSocket(SocketChannel socketChannel) throws TTransportException, IOException {
        this(socketChannel, 0, null);
        if (!socketChannel.isConnected()) {
            throw new IOException("Socket must already be connected");
        }
    }

    private TNonblockingSocket(SocketChannel socketChannel, int timeout, SocketAddress socketAddress) throws TTransportException, IOException {
        try {
            socketChannel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new TTransportException(e);
        }
        this.socketAddress = socketAddress;
        this.socketChannel = socketChannel;
        this.socket_ = socketChannel.socket();
        try {
            this.socket_.setSoLinger(false, 0);
            this.socket_.setTcpNoDelay(true);
        }
        catch (SocketException sx) {
            sx.printStackTrace();
        }
    }

    @Override
    public SelectionKey registerSelector(Selector selector, int interests) throws IOException {
        return this.socketChannel.register(selector, interests);
    }

    private void initSocket() {
        this.socket_ = new Socket();
        try {
            this.socket_.setSoLinger(false, 0);
            this.socket_.setTcpNoDelay(true);
            this.socket_.setSoTimeout(this.timeout_);
        }
        catch (SocketException sx) {
            sx.printStackTrace();
        }
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
        try {
            this.socket_.setSoTimeout(timeout);
        }
        catch (SocketException sx) {
            sx.printStackTrace();
        }
    }

    @Override
    public Socket getSocket() {
        if (this.socket_ == null) {
            this.initSocket();
        }
        return this.socket_;
    }

    @Override
    public boolean isOpen() {
        if (this.socket_ == null) {
            return false;
        }
        return this.socket_.isConnected();
    }

    @Override
    public void open() throws TTransportException {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        return this.socketChannel.read(buffer);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        if ((this.socketChannel.validOps() & 1) != 1) {
            throw new TTransportException(1, "Cannot read from write-only socket channel");
        }
        try {
            return this.socketChannel.read(ByteBuffer.wrap(buf, off, len));
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        return this.socketChannel.write(buffer);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        if ((this.socketChannel.validOps() & 4) != 4) {
            throw new TTransportException(1, "Cannot write to write-only socket channel");
        }
        try {
            this.socketChannel.write(ByteBuffer.wrap(buf, off, len));
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }

    @Override
    public void flush() throws TTransportException {
    }

    @Override
    public void close() {
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean startConnect() throws IOException {
        return this.socketChannel.connect(this.socketAddress);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }
}

