/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.google.common.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.flink.connector.nebula.shaded.com.google.common.base.Preconditions;
import org.apache.flink.connector.nebula.shaded.com.google.common.io.CharStreams;
import org.apache.flink.connector.nebula.shaded.com.google.common.io.Closer;

public abstract class CharSink {
    public abstract Writer openStream() throws IOException;

    public BufferedWriter openBufferedStream() throws IOException {
        Writer writer = this.openStream();
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public void write(CharSequence charSequence) throws IOException {
        Preconditions.checkNotNull(charSequence);
        Closer closer = Closer.create();
        try {
            Writer out = closer.register(this.openStream());
            out.append(charSequence);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public void writeLines(Iterable<? extends CharSequence> lines) throws IOException {
        this.writeLines(lines, System.getProperty("line.separator"));
    }

    public void writeLines(Iterable<? extends CharSequence> lines, String lineSeparator) throws IOException {
        Preconditions.checkNotNull(lines);
        Preconditions.checkNotNull(lineSeparator);
        Closer closer = Closer.create();
        try {
            BufferedWriter out = closer.register(this.openBufferedStream());
            for (CharSequence charSequence : lines) {
                out.append(charSequence).append(lineSeparator);
            }
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public long writeFrom(Readable readable) throws IOException {
        Preconditions.checkNotNull(readable);
        Closer closer = Closer.create();
        try {
            Writer out = closer.register(this.openStream());
            long l = CharStreams.copy(readable, (Appendable)out);
            return l;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }
}

