/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.bouncycastle.operator.bc;

import java.io.IOException;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.crypto.ExtendedDigest;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.crypto.Signer;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.crypto.signers.DSADigestSigner;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.crypto.signers.ECDSASigner;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.crypto.util.PublicKeyFactory;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcECContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new ECDSASigner(), extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

