/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.locate;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.PointLocation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryCollection;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryCollectionIterator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LinearRing;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygon;

public class SimplePointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry geom;

    public static int locate(Coordinate p, Geometry geom) {
        if (geom.isEmpty()) {
            return 2;
        }
        if (!geom.getEnvelopeInternal().intersects(p)) {
            return 2;
        }
        return SimplePointInAreaLocator.locateInGeometry(p, geom);
    }

    public static boolean isContained(Coordinate p, Geometry geom) {
        return 2 != SimplePointInAreaLocator.locate(p, geom);
    }

    private static int locateInGeometry(Coordinate p, Geometry geom) {
        if (geom instanceof Polygon) {
            return SimplePointInAreaLocator.locatePointInPolygon(p, (Polygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                int loc;
                Geometry g2 = (Geometry)geomi.next();
                if (g2 == geom || (loc = SimplePointInAreaLocator.locateInGeometry(p, g2)) == 2) continue;
                return loc;
            }
        }
        return 2;
    }

    public static int locatePointInPolygon(Coordinate p, Polygon poly) {
        if (poly.isEmpty()) {
            return 2;
        }
        LinearRing shell = (LinearRing)poly.getExteriorRing();
        int shellLoc = SimplePointInAreaLocator.locatePointInRing(p, shell);
        if (shellLoc != 0) {
            return shellLoc;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)poly.getInteriorRingN(i);
            int holeLoc = SimplePointInAreaLocator.locatePointInRing(p, hole);
            if (holeLoc == 1) {
                return 1;
            }
            if (holeLoc != 0) continue;
            return 2;
        }
        return 0;
    }

    public static boolean containsPointInPolygon(Coordinate p, Polygon poly) {
        return 2 != SimplePointInAreaLocator.locatePointInPolygon(p, poly);
    }

    private static int locatePointInRing(Coordinate p, LinearRing ring) {
        if (!ring.getEnvelopeInternal().intersects(p)) {
            return 2;
        }
        return PointLocation.locateInRing(p, ring.getCoordinates());
    }

    public SimplePointInAreaLocator(Geometry geom) {
        this.geom = geom;
    }

    @Override
    public int locate(Coordinate p) {
        return SimplePointInAreaLocator.locate(p, this.geom);
    }
}

