/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.edgegraph;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.Orientation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.Quadrant;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.util.Assert;

public class HalfEdge {
    private Coordinate orig;
    private HalfEdge sym;
    private HalfEdge next;

    public static HalfEdge create(Coordinate p0, Coordinate p1) {
        HalfEdge e0 = new HalfEdge(p0);
        HalfEdge e1 = new HalfEdge(p1);
        e0.init(e1);
        return e0;
    }

    public static HalfEdge init(HalfEdge e0, HalfEdge e1) {
        if (e0.sym != null || e1.sym != null || e0.next != null || e1.next != null) {
            throw new IllegalStateException("Edges are already initialized");
        }
        e0.init(e1);
        return e0;
    }

    public HalfEdge(Coordinate orig) {
        this.orig = orig;
    }

    protected void init(HalfEdge e) {
        this.setSym(e);
        e.setSym(this);
        this.setNext(e);
        e.setNext(this);
    }

    public Coordinate orig() {
        return this.orig;
    }

    public Coordinate dest() {
        return this.sym.orig;
    }

    public HalfEdge sym() {
        return this.sym;
    }

    private void setSym(HalfEdge e) {
        this.sym = e;
    }

    public HalfEdge next() {
        return this.next;
    }

    public HalfEdge prev() {
        return this.sym.next().sym;
    }

    public void setNext(HalfEdge e) {
        this.next = e;
    }

    public HalfEdge oNext() {
        return this.sym.next;
    }

    public HalfEdge find(Coordinate dest) {
        HalfEdge oNext = this;
        do {
            if (oNext == null) {
                return null;
            }
            if (!oNext.dest().equals2D(dest)) continue;
            return oNext;
        } while ((oNext = oNext.oNext()) != this);
        return null;
    }

    public boolean equals(Coordinate p0, Coordinate p1) {
        return this.orig.equals2D(p0) && this.sym.orig.equals(p1);
    }

    public void insert(HalfEdge e) {
        HalfEdge oNext;
        if (this.oNext() == this) {
            this.insertAfter(e);
            return;
        }
        int ecmp = this.compareTo(e);
        HalfEdge ePrev = this;
        do {
            int cmp;
            if ((cmp = (oNext = ePrev.oNext()).compareTo(e)) == ecmp && oNext != this) continue;
            ePrev.insertAfter(e);
            return;
        } while ((ePrev = oNext) != this);
        Assert.shouldNeverReachHere();
    }

    private void insertAfter(HalfEdge e) {
        Assert.equals(this.orig, e.orig());
        HalfEdge save = this.oNext();
        this.sym.setNext(e);
        e.sym().setNext(save);
    }

    public int compareTo(Object obj) {
        HalfEdge e = (HalfEdge)obj;
        int comp = this.compareAngularDirection(e);
        return comp;
    }

    public int compareAngularDirection(HalfEdge e) {
        double quadrant2;
        double dx = this.deltaX();
        double dy = this.deltaY();
        double dx2 = e.deltaX();
        double dy2 = e.deltaY();
        if (dx == dx2 && dy == dy2) {
            return 0;
        }
        double quadrant = Quadrant.quadrant(dx, dy);
        if (quadrant > (quadrant2 = (double)Quadrant.quadrant(dx2, dy2))) {
            return 1;
        }
        if (quadrant < quadrant2) {
            return -1;
        }
        return Orientation.index(e.orig, e.dest(), this.dest());
    }

    public double deltaX() {
        return this.sym.orig.x - this.orig.x;
    }

    public double deltaY() {
        return this.sym.orig.y - this.orig.y;
    }

    public String toString() {
        return "HE(" + this.orig.x + " " + this.orig.y + ", " + this.sym.orig.x + " " + this.sym.orig.y + ")";
    }

    public int degree() {
        int degree = 0;
        HalfEdge e = this;
        do {
            ++degree;
        } while ((e = e.oNext()) != this);
        return degree;
    }

    public HalfEdge prevNode() {
        HalfEdge e = this;
        while (e.degree() == 2) {
            if ((e = e.prev()) != this) continue;
            return null;
        }
        return e;
    }
}

