/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;

public class CoordinateXYM
extends Coordinate {
    private static final long serialVersionUID = 2842127537691165613L;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = -1;
    public static final int M = 2;
    protected double m;

    public CoordinateXYM() {
        this.m = 0.0;
    }

    public CoordinateXYM(double x, double y, double m) {
        super(x, y, Double.NaN);
        this.m = m;
    }

    public CoordinateXYM(Coordinate coord) {
        super(coord.x, coord.y);
        this.m = this.getM();
    }

    public CoordinateXYM(CoordinateXYM coord) {
        super(coord.x, coord.y);
        this.m = coord.m;
    }

    @Override
    public CoordinateXYM copy() {
        return new CoordinateXYM(this);
    }

    @Override
    public double getM() {
        return this.m;
    }

    @Override
    public void setM(double m) {
        this.m = m;
    }

    @Override
    public double getZ() {
        return Double.NaN;
    }

    @Override
    public void setZ(double z) {
        throw new IllegalArgumentException("CoordinateXY dimension 2 does not support z-ordinate");
    }

    @Override
    public void setCoordinate(Coordinate other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.getZ();
        this.m = other.getM();
    }

    @Override
    public double getOrdinate(int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.m;
            }
        }
        throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
    }

    @Override
    public void setOrdinate(int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.m = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
            }
        }
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + " m=" + this.getM() + ")";
    }
}

