/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygon;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygonal;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep.BasicPreparedGeometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep.PreparedPolygonContains;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep.PreparedPolygonContainsProperly;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep.PreparedPolygonCovers;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep.PreparedPolygonIntersects;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.FastSegmentSetIntersectionFinder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.SegmentStringUtil;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.predicate.RectangleContains;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.predicate.RectangleIntersects;

public class PreparedPolygon
extends BasicPreparedGeometry {
    private final boolean isRectangle = this.getGeometry().isRectangle();
    private FastSegmentSetIntersectionFinder segIntFinder = null;
    private PointOnGeometryLocator pia = null;

    public PreparedPolygon(Polygonal poly) {
        super((Geometry)((Object)poly));
    }

    public synchronized FastSegmentSetIntersectionFinder getIntersectionFinder() {
        if (this.segIntFinder == null) {
            this.segIntFinder = new FastSegmentSetIntersectionFinder(SegmentStringUtil.extractSegmentStrings(this.getGeometry()));
        }
        return this.segIntFinder;
    }

    public synchronized PointOnGeometryLocator getPointLocator() {
        if (this.pia == null) {
            this.pia = new IndexedPointInAreaLocator(this.getGeometry());
        }
        return this.pia;
    }

    @Override
    public boolean intersects(Geometry g) {
        if (!this.envelopesIntersect(g)) {
            return false;
        }
        if (this.isRectangle) {
            return RectangleIntersects.intersects((Polygon)this.getGeometry(), g);
        }
        return PreparedPolygonIntersects.intersects(this, g);
    }

    @Override
    public boolean contains(Geometry g) {
        if (!this.envelopeCovers(g)) {
            return false;
        }
        if (this.isRectangle) {
            return RectangleContains.contains((Polygon)this.getGeometry(), g);
        }
        return PreparedPolygonContains.contains(this, g);
    }

    @Override
    public boolean containsProperly(Geometry g) {
        if (!this.envelopeCovers(g)) {
            return false;
        }
        return PreparedPolygonContainsProperly.containsProperly(this, g);
    }

    @Override
    public boolean covers(Geometry g) {
        if (!this.envelopeCovers(g)) {
            return false;
        }
        if (this.isRectangle) {
            return true;
        }
        return PreparedPolygonCovers.covers(this, g);
    }
}

