/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.LineIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Envelope;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.IntersectionMatrix;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.Depth;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.EdgeIntersection;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.EdgeIntersectionList;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.GraphComponent;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.Label;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.index.MonotoneChainEdge;

public class Edge
extends GraphComponent {
    Coordinate[] pts;
    private Envelope env;
    EdgeIntersectionList eiList = new EdgeIntersectionList(this);
    private String name;
    private MonotoneChainEdge mce;
    private boolean isIsolated = true;
    private Depth depth = new Depth();
    private int depthDelta = 0;

    public static void updateIM(Label label, IntersectionMatrix im) {
        im.setAtLeastIfValid(label.getLocation(0, 0), label.getLocation(1, 0), 1);
        if (label.isArea()) {
            im.setAtLeastIfValid(label.getLocation(0, 1), label.getLocation(1, 1), 2);
            im.setAtLeastIfValid(label.getLocation(0, 2), label.getLocation(1, 2), 2);
        }
    }

    public Edge(Coordinate[] pts, Label label) {
        this.pts = pts;
        this.label = label;
    }

    public Edge(Coordinate[] pts) {
        this(pts, null);
    }

    public int getNumPoints() {
        return this.pts.length;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate getCoordinate(int i) {
        return this.pts[i];
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.pts.length > 0) {
            return this.pts[0];
        }
        return null;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            this.env = new Envelope();
            for (int i = 0; i < this.pts.length; ++i) {
                this.env.expandToInclude(this.pts[i]);
            }
        }
        return this.env;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public void setDepthDelta(int depthDelta) {
        this.depthDelta = depthDelta;
    }

    public int getMaximumSegmentIndex() {
        return this.pts.length - 1;
    }

    public EdgeIntersectionList getEdgeIntersectionList() {
        return this.eiList;
    }

    public MonotoneChainEdge getMonotoneChainEdge() {
        if (this.mce == null) {
            this.mce = new MonotoneChainEdge(this);
        }
        return this.mce;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public boolean isCollapsed() {
        if (!this.label.isArea()) {
            return false;
        }
        if (this.pts.length != 3) {
            return false;
        }
        return this.pts[0].equals(this.pts[2]);
    }

    public Edge getCollapsedEdge() {
        Coordinate[] newPts = new Coordinate[]{this.pts[0], this.pts[1]};
        Edge newe = new Edge(newPts, Label.toLineLabel(this.label));
        return newe;
    }

    public void setIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    @Override
    public boolean isIsolated() {
        return this.isIsolated;
    }

    public void addIntersections(LineIntersector li, int segmentIndex, int geomIndex) {
        for (int i = 0; i < li.getIntersectionNum(); ++i) {
            this.addIntersection(li, segmentIndex, geomIndex, i);
        }
    }

    public void addIntersection(LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate nextPt;
        Coordinate intPt = new Coordinate(li.getIntersection(intIndex));
        int normalizedSegmentIndex = segmentIndex;
        double dist = li.getEdgeDistance(geomIndex, intIndex);
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
            dist = 0.0;
        }
        EdgeIntersection ei = this.eiList.add(intPt, normalizedSegmentIndex, dist);
    }

    @Override
    public void computeIM(IntersectionMatrix im) {
        Edge.updateIM(this.label, im);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge e = (Edge)o;
        if (this.pts.length != e.pts.length) {
            return false;
        }
        boolean isEqualForward = true;
        boolean isEqualReverse = true;
        int iRev = this.pts.length;
        for (int i = 0; i < this.pts.length; ++i) {
            if (!this.pts[i].equals2D(e.pts[i])) {
                isEqualForward = false;
            }
            if (!this.pts[i].equals2D(e.pts[--iRev])) {
                isEqualReverse = false;
            }
            if (isEqualForward || isEqualReverse) continue;
            return false;
        }
        return true;
    }

    public boolean isPointwiseEqual(Edge e) {
        if (this.pts.length != e.pts.length) {
            return false;
        }
        for (int i = 0; i < this.pts.length; ++i) {
            if (this.pts[i].equals2D(e.pts[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("edge " + this.name + ": ");
        builder.append("LINESTRING (");
        for (int i = 0; i < this.pts.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.pts[i].x + " " + this.pts[i].y);
        }
        builder.append(")  " + this.label + " " + this.depthDelta);
        return builder.toString();
    }

    public void print(PrintStream out) {
        out.print("edge " + this.name + ": ");
        out.print("LINESTRING (");
        for (int i = 0; i < this.pts.length; ++i) {
            if (i > 0) {
                out.print(",");
            }
            out.print(this.pts[i].x + " " + this.pts[i].y);
        }
        out.print(")  " + this.label + " " + this.depthDelta);
    }

    public void printReverse(PrintStream out) {
        out.print("edge " + this.name + ": ");
        for (int i = this.pts.length - 1; i >= 0; --i) {
            out.print(this.pts[i] + " ");
        }
        out.println("");
    }
}

