/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.bintree;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.bintree.Interval;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.bintree.Key;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.bintree.NodeBase;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.util.Assert;

public class Node
extends NodeBase {
    private Interval interval;
    private double centre;
    private int level;

    public static Node createNode(Interval itemInterval) {
        Key key = new Key(itemInterval);
        Node node = new Node(key.getInterval(), key.getLevel());
        return node;
    }

    public static Node createExpanded(Node node, Interval addInterval) {
        Interval expandInt = new Interval(addInterval);
        if (node != null) {
            expandInt.expandToInclude(node.interval);
        }
        Node largerNode = Node.createNode(expandInt);
        if (node != null) {
            largerNode.insert(node);
        }
        return largerNode;
    }

    public Node(Interval interval, int level) {
        this.interval = interval;
        this.level = level;
        this.centre = (interval.getMin() + interval.getMax()) / 2.0;
    }

    public Interval getInterval() {
        return this.interval;
    }

    @Override
    protected boolean isSearchMatch(Interval itemInterval) {
        return itemInterval.overlaps(this.interval);
    }

    public Node getNode(Interval searchInterval) {
        int subnodeIndex = Node.getSubnodeIndex(searchInterval, this.centre);
        if (subnodeIndex != -1) {
            Node node = this.getSubnode(subnodeIndex);
            return node.getNode(searchInterval);
        }
        return this;
    }

    public NodeBase find(Interval searchInterval) {
        int subnodeIndex = Node.getSubnodeIndex(searchInterval, this.centre);
        if (subnodeIndex == -1) {
            return this;
        }
        if (this.subnode[subnodeIndex] != null) {
            Node node = this.subnode[subnodeIndex];
            return node.find(searchInterval);
        }
        return this;
    }

    void insert(Node node) {
        Assert.isTrue(this.interval == null || this.interval.contains(node.interval));
        int index = Node.getSubnodeIndex(node.interval, this.centre);
        if (node.level == this.level - 1) {
            this.subnode[index] = node;
        } else {
            Node childNode = this.createSubnode(index);
            childNode.insert(node);
            this.subnode[index] = childNode;
        }
    }

    private Node getSubnode(int index) {
        if (this.subnode[index] == null) {
            this.subnode[index] = this.createSubnode(index);
        }
        return this.subnode[index];
    }

    private Node createSubnode(int index) {
        double min = 0.0;
        double max = 0.0;
        switch (index) {
            case 0: {
                min = this.interval.getMin();
                max = this.centre;
                break;
            }
            case 1: {
                min = this.centre;
                max = this.interval.getMax();
            }
        }
        Interval subInt = new Interval(min, max);
        Node node = new Node(subInt, this.level - 1);
        return node;
    }
}

