/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateList;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.MultiLineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LinearGeometryBuilder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LinearIterator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LinearLocation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.util.Assert;

class ExtractLineByLocation {
    private Geometry line;

    public static Geometry extract(Geometry line, LinearLocation start, LinearLocation end) {
        ExtractLineByLocation ls = new ExtractLineByLocation(line);
        return ls.extract(start, end);
    }

    public ExtractLineByLocation(Geometry line) {
        this.line = line;
    }

    public Geometry extract(LinearLocation start, LinearLocation end) {
        if (end.compareTo(start) < 0) {
            return this.reverse(this.computeLinear(end, start));
        }
        return this.computeLinear(start, end);
    }

    private Geometry reverse(Geometry linear) {
        if (linear instanceof LineString) {
            return ((LineString)linear).reverse();
        }
        if (linear instanceof MultiLineString) {
            return ((MultiLineString)linear).reverse();
        }
        Assert.shouldNeverReachHere("non-linear geometry encountered");
        return null;
    }

    private LineString computeLine(LinearLocation start, LinearLocation end) {
        Coordinate[] newCoordinateArray;
        Coordinate[] coordinates = this.line.getCoordinates();
        CoordinateList newCoordinates = new CoordinateList();
        int startSegmentIndex = start.getSegmentIndex();
        if (start.getSegmentFraction() > 0.0) {
            ++startSegmentIndex;
        }
        int lastSegmentIndex = end.getSegmentIndex();
        if (end.getSegmentFraction() == 1.0) {
            ++lastSegmentIndex;
        }
        if (lastSegmentIndex >= coordinates.length) {
            lastSegmentIndex = coordinates.length - 1;
        }
        if (!start.isVertex()) {
            newCoordinates.add(start.getCoordinate(this.line));
        }
        for (int i = startSegmentIndex; i <= lastSegmentIndex; ++i) {
            newCoordinates.add(coordinates[i]);
        }
        if (!end.isVertex()) {
            newCoordinates.add(end.getCoordinate(this.line));
        }
        if (newCoordinates.size() <= 0) {
            newCoordinates.add(start.getCoordinate(this.line));
        }
        if ((newCoordinateArray = newCoordinates.toCoordinateArray()).length <= 1) {
            newCoordinateArray = new Coordinate[]{newCoordinateArray[0], newCoordinateArray[0]};
        }
        return this.line.getFactory().createLineString(newCoordinateArray);
    }

    private Geometry computeLinear(LinearLocation start, LinearLocation end) {
        LinearGeometryBuilder builder = new LinearGeometryBuilder(this.line.getFactory());
        builder.setFixInvalidLines(true);
        if (!start.isVertex()) {
            builder.add(start.getCoordinate(this.line));
        }
        LinearIterator it = new LinearIterator(this.line, start);
        while (it.hasNext() && end.compareLocationValues(it.getComponentIndex(), it.getVertexIndex(), 0.0) >= 0) {
            Coordinate pt = it.getSegmentStart();
            builder.add(pt);
            if (it.isEndOfLine()) {
                builder.endLine();
            }
            it.next();
        }
        if (!end.isVertex()) {
            builder.add(end.getCoordinate(this.line));
        }
        return builder.getGeometry();
    }
}

