/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LinearLocation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LocationIndexOfPoint;

class LocationIndexOfLine {
    private Geometry linearGeom;

    public static LinearLocation[] indicesOf(Geometry linearGeom, Geometry subLine) {
        LocationIndexOfLine locater = new LocationIndexOfLine(linearGeom);
        return locater.indicesOf(subLine);
    }

    public LocationIndexOfLine(Geometry linearGeom) {
        this.linearGeom = linearGeom;
    }

    public LinearLocation[] indicesOf(Geometry subLine) {
        LinearLocation[] subLineLoc;
        Coordinate startPt = ((LineString)subLine.getGeometryN(0)).getCoordinateN(0);
        LineString lastLine = (LineString)subLine.getGeometryN(subLine.getNumGeometries() - 1);
        Coordinate endPt = lastLine.getCoordinateN(lastLine.getNumPoints() - 1);
        LocationIndexOfPoint locPt = new LocationIndexOfPoint(this.linearGeom);
        subLineLoc = new LinearLocation[]{locPt.indexOf(startPt), subLine.getLength() == 0.0 ? subLineLoc[0].copy() : locPt.indexOfAfter(endPt, subLineLoc[0])};
        return subLineLoc;
    }
}

