/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;

public class Octant {
    public static int octant(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            throw new IllegalArgumentException("Cannot compute the octant for point ( " + dx + ", " + dy + " )");
        }
        double adx = Math.abs(dx);
        double ady = Math.abs(dy);
        if (dx >= 0.0) {
            if (dy >= 0.0) {
                if (adx >= ady) {
                    return 0;
                }
                return 1;
            }
            if (adx >= ady) {
                return 7;
            }
            return 6;
        }
        if (dy >= 0.0) {
            if (adx >= ady) {
                return 3;
            }
            return 2;
        }
        if (adx >= ady) {
            return 4;
        }
        return 5;
    }

    public static int octant(Coordinate p0, Coordinate p1) {
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        if (dx == 0.0 && dy == 0.0) {
            throw new IllegalArgumentException("Cannot compute the octant for two identical points " + p0);
        }
        return Octant.octant(dx, dy);
    }

    private Octant() {
    }
}

