/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.LineIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.RobustLineIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.SegmentIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.SegmentString;

public class SegmentIntersectionDetector
implements SegmentIntersector {
    private LineIntersector li;
    private boolean findProper = false;
    private boolean findAllTypes = false;
    private boolean hasIntersection = false;
    private boolean hasProperIntersection = false;
    private boolean hasNonProperIntersection = false;
    private Coordinate intPt = null;
    private Coordinate[] intSegments = null;

    public SegmentIntersectionDetector() {
        this(new RobustLineIntersector());
    }

    public SegmentIntersectionDetector(LineIntersector li) {
        this.li = li;
    }

    public void setFindProper(boolean findProper) {
        this.findProper = findProper;
    }

    public void setFindAllIntersectionTypes(boolean findAllTypes) {
        this.findAllTypes = findAllTypes;
    }

    public boolean hasIntersection() {
        return this.hasIntersection;
    }

    public boolean hasProperIntersection() {
        return this.hasProperIntersection;
    }

    public boolean hasNonProperIntersection() {
        return this.hasNonProperIntersection;
    }

    public Coordinate getIntersection() {
        return this.intPt;
    }

    public Coordinate[] getIntersectionSegments() {
        return this.intSegments;
    }

    @Override
    public void processIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinates()[segIndex0];
        Coordinate p01 = e0.getCoordinates()[segIndex0 + 1];
        Coordinate p10 = e1.getCoordinates()[segIndex1];
        Coordinate p11 = e1.getCoordinates()[segIndex1 + 1];
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection()) {
            this.hasIntersection = true;
            boolean isProper = this.li.isProper();
            if (isProper) {
                this.hasProperIntersection = true;
            }
            if (!isProper) {
                this.hasNonProperIntersection = true;
            }
            boolean saveLocation = true;
            if (this.findProper && !isProper) {
                saveLocation = false;
            }
            if (this.intPt == null || saveLocation) {
                this.intPt = this.li.getIntersection(0);
                this.intSegments = new Coordinate[4];
                this.intSegments[0] = p00;
                this.intSegments[1] = p01;
                this.intSegments[2] = p10;
                this.intSegments[3] = p11;
            }
        }
    }

    @Override
    public boolean isDone() {
        if (this.findAllTypes) {
            return this.hasProperIntersection && this.hasNonProperIntersection;
        }
        if (this.findProper) {
            return this.hasProperIntersection;
        }
        return this.hasIntersection;
    }
}

