/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.Distance;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.Orientation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateArrays;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Envelope;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryCollection;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LinearRing;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.MultiLineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.MultiPoint;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.MultiPolygon;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Point;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygon;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Triangle;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.Label;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.Position;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.NodedSegmentString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.buffer.OffsetCurveBuilder;

public class OffsetCurveSetBuilder {
    private Geometry inputGeom;
    private double distance;
    private OffsetCurveBuilder curveBuilder;
    private List curveList = new ArrayList();

    public OffsetCurveSetBuilder(Geometry inputGeom, double distance, OffsetCurveBuilder curveBuilder) {
        this.inputGeom = inputGeom;
        this.distance = distance;
        this.curveBuilder = curveBuilder;
    }

    public List getCurves() {
        this.add(this.inputGeom);
        return this.curveList;
    }

    private void addCurve(Coordinate[] coord, int leftLoc, int rightLoc) {
        if (coord == null || coord.length < 2) {
            return;
        }
        NodedSegmentString e = new NodedSegmentString(coord, new Label(0, 1, leftLoc, rightLoc));
        this.curveList.add(e);
    }

    private void add(Geometry g) {
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof Polygon) {
            this.addPolygon((Polygon)g);
        } else if (g instanceof LineString) {
            this.addLineString((LineString)g);
        } else if (g instanceof Point) {
            this.addPoint((Point)g);
        } else if (g instanceof MultiPoint) {
            this.addCollection((MultiPoint)g);
        } else if (g instanceof MultiLineString) {
            this.addCollection((MultiLineString)g);
        } else if (g instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)g);
        } else if (g instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(g.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g);
        }
    }

    private void addPoint(Point p) {
        if (this.distance <= 0.0) {
            return;
        }
        Coordinate[] coord = p.getCoordinates();
        Coordinate[] curve = this.curveBuilder.getLineCurve(coord, this.distance);
        this.addCurve(curve, 2, 0);
    }

    private void addLineString(LineString line) {
        if (this.distance <= 0.0 && !this.curveBuilder.getBufferParameters().isSingleSided()) {
            return;
        }
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints(line.getCoordinates());
        Coordinate[] curve = this.curveBuilder.getLineCurve(coord, this.distance);
        this.addCurve(curve, 2, 0);
    }

    private void addPolygon(Polygon p) {
        double offsetDistance = this.distance;
        int offsetSide = 1;
        if (this.distance < 0.0) {
            offsetDistance = -this.distance;
            offsetSide = 2;
        }
        LinearRing shell = (LinearRing)p.getExteriorRing();
        Coordinate[] shellCoord = CoordinateArrays.removeRepeatedPoints(shell.getCoordinates());
        if (this.distance < 0.0 && this.isErodedCompletely(shell, this.distance)) {
            return;
        }
        if (this.distance <= 0.0 && shellCoord.length < 3) {
            return;
        }
        this.addPolygonRing(shellCoord, offsetDistance, offsetSide, 2, 0);
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)p.getInteriorRingN(i);
            Coordinate[] holeCoord = CoordinateArrays.removeRepeatedPoints(hole.getCoordinates());
            if (this.distance > 0.0 && this.isErodedCompletely(hole, -this.distance)) continue;
            this.addPolygonRing(holeCoord, offsetDistance, Position.opposite(offsetSide), 0, 2);
        }
    }

    private void addPolygonRing(Coordinate[] coord, double offsetDistance, int side, int cwLeftLoc, int cwRightLoc) {
        if (offsetDistance == 0.0 && coord.length < 4) {
            return;
        }
        int leftLoc = cwLeftLoc;
        int rightLoc = cwRightLoc;
        if (coord.length >= 4 && Orientation.isCCW(coord)) {
            leftLoc = cwRightLoc;
            rightLoc = cwLeftLoc;
            side = Position.opposite(side);
        }
        Coordinate[] curve = this.curveBuilder.getRingCurve(coord, side, offsetDistance);
        this.addCurve(curve, leftLoc, rightLoc);
    }

    private boolean isErodedCompletely(LinearRing ring, double bufferDistance) {
        Coordinate[] ringCoord = ring.getCoordinates();
        if (ringCoord.length < 4) {
            return bufferDistance < 0.0;
        }
        if (ringCoord.length == 4) {
            return this.isTriangleErodedCompletely(ringCoord, bufferDistance);
        }
        Envelope env = ring.getEnvelopeInternal();
        double envMinDimension = Math.min(env.getHeight(), env.getWidth());
        return bufferDistance < 0.0 && 2.0 * Math.abs(bufferDistance) > envMinDimension;
    }

    private boolean isTriangleErodedCompletely(Coordinate[] triangleCoord, double bufferDistance) {
        Triangle tri = new Triangle(triangleCoord[0], triangleCoord[1], triangleCoord[2]);
        Coordinate inCentre = tri.inCentre();
        double distToCentre = Distance.pointToSegment(inCentre, tri.p0, tri.p1);
        return distToCentre < Math.abs(bufferDistance);
    }
}

