/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.distance;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.strtree.ItemBoundable;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.strtree.ItemDistance;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.strtree.STRtree;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.distance.FacetSequence;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.distance.FacetSequenceTreeBuilder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.distance.GeometryLocation;

public class IndexedFacetDistance {
    private STRtree cachedTree;

    public static double distance(Geometry g1, Geometry g2) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.distance(g2);
    }

    public static Coordinate[] nearestPoints(Geometry g1, Geometry g2) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.nearestPoints(g2);
    }

    public IndexedFacetDistance(Geometry g1) {
        this.cachedTree = FacetSequenceTreeBuilder.build(g1);
    }

    public double distance(Geometry g) {
        STRtree tree2 = FacetSequenceTreeBuilder.build(g);
        Object[] obj = this.cachedTree.nearestNeighbour(tree2, new FacetSequenceDistance());
        FacetSequence fs1 = (FacetSequence)obj[0];
        FacetSequence fs2 = (FacetSequence)obj[1];
        return fs1.distance(fs2);
    }

    public GeometryLocation[] nearestLocations(Geometry g) {
        STRtree tree2 = FacetSequenceTreeBuilder.build(g);
        Object[] obj = this.cachedTree.nearestNeighbour(tree2, new FacetSequenceDistance());
        FacetSequence fs1 = (FacetSequence)obj[0];
        FacetSequence fs2 = (FacetSequence)obj[1];
        return fs1.nearestLocations(fs2);
    }

    public Coordinate[] nearestPoints(Geometry g) {
        GeometryLocation[] minDistanceLocation = this.nearestLocations(g);
        Coordinate[] nearestPts = new Coordinate[]{minDistanceLocation[0].getCoordinate(), minDistanceLocation[1].getCoordinate()};
        return nearestPts;
    }

    private static class FacetSequenceDistance
    implements ItemDistance {
        private FacetSequenceDistance() {
        }

        @Override
        public double distance(ItemBoundable item1, ItemBoundable item2) {
            FacetSequence fs1 = (FacetSequence)item1.getItem();
            FacetSequence fs2 = (FacetSequence)item2.getItem();
            return fs1.distance(fs2);
        }
    }
}

