/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.sink;

import com.esotericsoftware.minlog.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.nebula.statement.EdgeExecutionOptions;
import org.apache.flink.connector.nebula.utils.NebulaEdge;
import org.apache.flink.connector.nebula.utils.NebulaUtils;
import org.apache.flink.connector.nebula.utils.PolicyEnum;
import org.apache.flink.connector.nebula.utils.VidTypeEnum;
import org.apache.flink.types.Row;

public class NebulaRowEdgeOutputFormatConverter
implements Serializable {
    private final int srcIdIndex;
    private final int dstIdIndex;
    private final int rankIndex;
    private final VidTypeEnum vidType;
    private final List<Integer> positions;
    private final Map<Integer, String> pos2Field;
    private final Map<String, Integer> schema;

    public NebulaRowEdgeOutputFormatConverter(EdgeExecutionOptions executionOptions, VidTypeEnum vidType, Map<String, Integer> schema) {
        this.srcIdIndex = executionOptions.getSrcIndex();
        this.dstIdIndex = executionOptions.getDstIndex();
        this.rankIndex = executionOptions.getRankIndex();
        this.vidType = vidType;
        this.schema = schema;
        this.positions = executionOptions.getPositions();
        this.pos2Field = new HashMap<Integer, String>();
        List<String> fields = executionOptions.getFields();
        for (int i = 0; i < this.positions.size(); ++i) {
            this.pos2Field.put(this.positions.get(i), fields.get(i));
        }
    }

    public NebulaEdge createEdge(Row row, PolicyEnum policy) {
        if (row == null || row.getArity() == 0) {
            Log.error((String)"empty row");
            return null;
        }
        Object srcId = row.getField(this.srcIdIndex);
        Object dstId = row.getField(this.dstIdIndex);
        if (srcId == null || dstId == null) {
            Log.error((String)"null srcId or dstId");
            return null;
        }
        ArrayList<String> edgeProps = new ArrayList<String>();
        for (int i : this.positions) {
            String propName = this.pos2Field.get(i);
            int type = this.schema.get(propName);
            edgeProps.add(NebulaUtils.extraValue(row.getField(i), type));
        }
        String srcFormatId = srcId.toString();
        String dstFormatId = dstId.toString();
        if (policy == null) {
            if (this.vidType == VidTypeEnum.STRING) {
                srcFormatId = NebulaUtils.mkString(srcFormatId, "\"", "", "\"");
                dstFormatId = NebulaUtils.mkString(dstFormatId, "\"", "", "\"");
            } else {
                assert (NebulaUtils.isNumeric(srcFormatId));
                assert (NebulaUtils.isNumeric(dstFormatId));
            }
        } else assert (this.vidType == VidTypeEnum.INT);
        Long rank = null;
        if (this.rankIndex >= 0) {
            rank = row.getField(this.rankIndex) == null ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(row.getField(this.rankIndex).toString()));
        }
        NebulaEdge edge = new NebulaEdge(srcFormatId, dstFormatId, rank, edgeProps);
        return edge;
    }
}

