/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.sink;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.nebula.sink.NebulaBatchOutputFormat;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

public class NebulaSinkFunction<T>
extends RichSinkFunction<T>
implements CheckpointedFunction {
    private static final long serialVersionUID = 8100784397926666769L;
    private final NebulaBatchOutputFormat<T, ?> outputFormat;
    private final AtomicReference<Throwable> failureThrowable = new AtomicReference();

    public NebulaSinkFunction(NebulaBatchOutputFormat<T, ?> outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        RuntimeContext ctx = this.getRuntimeContext();
        this.outputFormat.setRuntimeContext(ctx);
        try {
            this.outputFormat.open(ctx.getIndexOfThisSubtask(), ctx.getNumberOfParallelSubtasks());
        }
        catch (IOException e) {
            this.failureThrowable.compareAndSet(null, e);
        }
    }

    public void close() {
        this.outputFormat.close();
    }

    public void invoke(T value, SinkFunction.Context context) {
        this.checkErrorAndRethrow();
        this.outputFormat.writeRecord(value);
    }

    public void snapshotState(FunctionSnapshotContext functionSnapshotContext) throws Exception {
        this.flush();
        this.checkErrorAndRethrow();
    }

    public void initializeState(FunctionInitializationContext functionInitializationContext) {
    }

    private void checkErrorAndRethrow() {
        Throwable cause = this.failureThrowable.get();
        if (cause != null) {
            throw new RuntimeException("An error occurred in NebulaSink.", cause);
        }
    }

    private void flush() throws IOException {
        this.outputFormat.flush();
    }
}

